/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sardine.util;

import com.googlecode.sardine.model.ObjectFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SardineUtil {
    public static final String CUSTOM_NAMESPACE_PREFIX = "s";
    public static final String CUSTOM_NAMESPACE_URI = "SAR:";
    public static final String DEFAULT_NAMESPACE_PREFIX = "d";
    public static final String DEFAULT_NAMESPACE_URI = "DAV:";
    private static final JAXBContext JAXB_CONTEXT;
    private static final List<ThreadLocal<SimpleDateFormat>> DATETIME_FORMATS;

    public static Date parseDate(String value) {
        if (value == null) {
            return null;
        }
        Date date = null;
        for (ThreadLocal<SimpleDateFormat> format : DATETIME_FORMATS) {
            try {
                date = format.get().parse(value);
                break;
            }
            catch (ParseException e) {
            }
        }
        return date;
    }

    public static <T> T unmarshal(InputStream in) throws IOException {
        Unmarshaller unmarshaller = SardineUtil.createUnmarshaller();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            try {
                reader.setFeature("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
            }
            catch (SAXException e) {
                // empty catch block
            }
            try {
                reader.setFeature("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
            }
            catch (SAXException e) {
                // empty catch block
            }
            try {
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
            }
            catch (SAXException e) {
                // empty catch block
            }
            try {
                reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            }
            catch (SAXException e) {
                // empty catch block
            }
            return (T)unmarshaller.unmarshal((Source)new SAXSource(reader, new InputSource(in)));
        }
        catch (SAXException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (JAXBException e) {
            IOException failure = new IOException("Not a valid DAV response");
            failure.initCause(e);
            throw failure;
        }
    }

    private static Unmarshaller createUnmarshaller() {
        try {
            return JAXB_CONTEXT.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static Marshaller createMarshaller() {
        try {
            return JAXB_CONTEXT.createMarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static Document createDocument() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return builder.newDocument();
    }

    public static String toXml(Object jaxbElement) {
        StringWriter writer = new StringWriter();
        try {
            Marshaller marshaller = SardineUtil.createMarshaller();
            marshaller.marshal(jaxbElement, (Writer)writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return writer.toString();
    }

    public static Map<QName, String> toQName(Map<String, String> setProps) {
        if (setProps == null) {
            return Collections.emptyMap();
        }
        HashMap<QName, String> result = new HashMap<QName, String>(setProps.size());
        for (Map.Entry<String, String> entry : setProps.entrySet()) {
            result.put(SardineUtil.createQNameWithCustomNamespace(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public static List<QName> toQName(List<String> removeProps) {
        if (removeProps == null) {
            return Collections.emptyList();
        }
        ArrayList<QName> result = new ArrayList<QName>(removeProps.size());
        for (String entry : removeProps) {
            result.add(SardineUtil.createQNameWithCustomNamespace(entry));
        }
        return result;
    }

    public static QName createQNameWithCustomNamespace(String key) {
        return new QName(CUSTOM_NAMESPACE_URI, key, CUSTOM_NAMESPACE_PREFIX);
    }

    public static QName createQNameWithDefaultNamespace(String key) {
        return new QName(DEFAULT_NAMESPACE_URI, key, DEFAULT_NAMESPACE_PREFIX);
    }

    public static Element createElement(QName key) {
        return SardineUtil.createDocument().createElementNS(key.getNamespaceURI(), key.getPrefix() + ":" + key.getLocalPart());
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        DATETIME_FORMATS = Arrays.asList(new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format;
            }
        }, new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format;
            }
        }, new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sss'Z'", Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format;
            }
        }, new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format;
            }
        }, new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format;
            }
        }, new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat format = new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format;
            }
        }, new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat format = new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format;
            }
        });
    }
}

