/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sardine.impl.handler;

import com.googlecode.sardine.impl.SardineException;
import com.googlecode.sardine.impl.handler.ValidatingResponseHandler;
import com.googlecode.sardine.model.Multistatus;
import com.googlecode.sardine.util.SardineUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiStatusResponseHandler
extends ValidatingResponseHandler<Multistatus> {
    @Override
    public Multistatus handleResponse(HttpResponse response) throws SardineException, IOException {
        super.validateResponse(response);
        HttpEntity entity = response.getEntity();
        StatusLine statusLine = response.getStatusLine();
        if (entity == null) {
            throw new SardineException("No entity found in response", statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return this.getMultistatus(entity.getContent());
    }

    protected Multistatus getMultistatus(InputStream stream) throws IOException {
        return (Multistatus)SardineUtil.unmarshal(stream);
    }
}

