/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sardine.impl;

import com.googlecode.sardine.DavResource;
import com.googlecode.sardine.Sardine;
import com.googlecode.sardine.Version;
import com.googlecode.sardine.impl.handler.ExistsResponseHandler;
import com.googlecode.sardine.impl.handler.LockResponseHandler;
import com.googlecode.sardine.impl.handler.MultiStatusResponseHandler;
import com.googlecode.sardine.impl.handler.VoidResponseHandler;
import com.googlecode.sardine.impl.io.ConsumingInputStream;
import com.googlecode.sardine.impl.methods.HttpCopy;
import com.googlecode.sardine.impl.methods.HttpLock;
import com.googlecode.sardine.impl.methods.HttpMkCol;
import com.googlecode.sardine.impl.methods.HttpMove;
import com.googlecode.sardine.impl.methods.HttpPropFind;
import com.googlecode.sardine.impl.methods.HttpPropPatch;
import com.googlecode.sardine.impl.methods.HttpUnlock;
import com.googlecode.sardine.model.Allprop;
import com.googlecode.sardine.model.Exclusive;
import com.googlecode.sardine.model.Lockinfo;
import com.googlecode.sardine.model.Lockscope;
import com.googlecode.sardine.model.Locktype;
import com.googlecode.sardine.model.Multistatus;
import com.googlecode.sardine.model.Prop;
import com.googlecode.sardine.model.Propertyupdate;
import com.googlecode.sardine.model.Propfind;
import com.googlecode.sardine.model.Remove;
import com.googlecode.sardine.model.Response;
import com.googlecode.sardine.model.Set;
import com.googlecode.sardine.model.Write;
import com.googlecode.sardine.util.SardineUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SardineImpl
implements Sardine {
    private static Logger log = LoggerFactory.getLogger(DavResource.class);
    private static final String UTF_8 = "UTF-8";
    private AbstractHttpClient client;
    private HttpContext context = new BasicHttpContext();

    public SardineImpl() {
        this(null, null);
    }

    public SardineImpl(String username, String password) {
        this(username, password, null);
    }

    public SardineImpl(String username, String password, ProxySelector selector) {
        this.init(this.createDefaultClient(selector), username, password);
    }

    public SardineImpl(AbstractHttpClient http) {
        this(http, null, null);
    }

    public SardineImpl(AbstractHttpClient http, String username, String password) {
        this.init(http, username, password);
    }

    private void init(AbstractHttpClient http, String username, String password) {
        this.client = http;
        this.client.setRedirectStrategy(new DefaultRedirectStrategy(){

            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                int statusCode = response.getStatusLine().getStatusCode();
                String method = request.getRequestLine().getMethod();
                Header locationHeader = response.getFirstHeader("location");
                switch (statusCode) {
                    case 302: {
                        return (method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("HEAD") || method.equalsIgnoreCase("PROPFIND")) && locationHeader != null;
                    }
                    case 301: 
                    case 307: {
                        return method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("HEAD") || method.equalsIgnoreCase("PROPFIND");
                    }
                    case 303: {
                        return true;
                    }
                }
                return false;
            }

            public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                URI uri = this.getLocationURI(request, response, context);
                String method = request.getRequestLine().getMethod();
                if (method.equalsIgnoreCase("HEAD")) {
                    return new HttpHead(uri);
                }
                if (method.equalsIgnoreCase("PROPFIND")) {
                    return new HttpPropFind(uri);
                }
                if (method.equalsIgnoreCase("LOCK")) {
                    return new HttpLock(uri);
                }
                return new HttpGet(uri);
            }
        });
        this.setCredentials(username, password);
    }

    @Override
    public void setCredentials(String username, String password) {
        this.setCredentials(username, password, "", "");
    }

    @Override
    public void setCredentials(String username, String password, String domain, String workstation) {
        if (username != null) {
            this.client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "NTLM"), new NTCredentials(username, password, workstation, domain));
            this.client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Basic"), new UsernamePasswordCredentials(username, password));
            this.client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Digest"), new UsernamePasswordCredentials(username, password));
        }
    }

    @Override
    public void enableCompression() {
        this.client.addRequestInterceptor(new RequestAcceptEncoding());
        this.client.addResponseInterceptor(new ResponseContentEncoding());
    }

    @Override
    public void disableCompression() {
        this.client.removeRequestInterceptorByClass(RequestAcceptEncoding.class);
        this.client.removeResponseInterceptorByClass(ResponseContentEncoding.class);
    }

    @Override
    public void enablePreemptiveAuthentication(String hostname) {
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        SchemeRegistry registry = this.client.getConnectionManager().getSchemeRegistry();
        for (String scheme : registry.getSchemeNames()) {
            int port = registry.getScheme(scheme).getDefaultPort();
            authCache.put(new HttpHost(hostname), basicAuth);
            authCache.put(new HttpHost(hostname, -1, scheme), basicAuth);
            authCache.put(new HttpHost(hostname, port, scheme), basicAuth);
        }
        this.context.setAttribute("http.auth.auth-cache", authCache);
    }

    @Override
    public void disablePreemptiveAuthentication() {
        this.context.removeAttribute("http.auth.auth-cache");
    }

    @Override
    public List<DavResource> getResources(String url) throws IOException {
        return this.list(url);
    }

    @Override
    public List<DavResource> list(String url) throws IOException {
        HttpPropFind entity = new HttpPropFind(url);
        Propfind body = new Propfind();
        body.setAllprop(new Allprop());
        entity.setEntity(new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute(entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        ArrayList<DavResource> resources = new ArrayList<DavResource>(responses.size());
        for (Response response : responses) {
            try {
                resources.add(new DavResource(response));
            }
            catch (URISyntaxException e) {
                log.warn(String.format("Ignore resource with invalid URI %s", response.getHref().get(0)));
            }
        }
        return resources;
    }

    @Override
    public void setCustomProps(String url, Map<String, String> set, List<String> remove) throws IOException {
        this.patch(url, SardineUtil.toQName(set), SardineUtil.toQName(remove));
    }

    @Override
    public List<DavResource> patch(String url, Map<QName, String> setProps) throws IOException {
        return this.patch(url, setProps, Collections.<QName>emptyList());
    }

    @Override
    public List<DavResource> patch(String url, Map<QName, String> setProps, List<QName> removeProps) throws IOException {
        Element element;
        HttpPropPatch entity = new HttpPropPatch(url);
        Propertyupdate body = new Propertyupdate();
        Set set = new Set();
        body.getRemoveOrSet().add(set);
        Prop prop = new Prop();
        List<Element> any = prop.getAny();
        for (Map.Entry<QName, String> entry : setProps.entrySet()) {
            element = SardineUtil.createElement(entry.getKey());
            element.setTextContent(entry.getValue());
            any.add(element);
        }
        set.setProp(prop);
        Remove remove = new Remove();
        body.getRemoveOrSet().add(remove);
        prop = new Prop();
        any = prop.getAny();
        for (QName qName : removeProps) {
            element = SardineUtil.createElement(qName);
            any.add(element);
        }
        remove.setProp(prop);
        entity.setEntity(new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute(entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        ArrayList<DavResource> resources = new ArrayList<DavResource>(responses.size());
        for (Response response : responses) {
            try {
                resources.add(new DavResource(response));
            }
            catch (URISyntaxException e) {
                log.warn(String.format("Ignore resource with invalid URI %s", response.getHref().get(0)));
            }
        }
        return resources;
    }

    @Override
    public String lock(String url) throws IOException {
        HttpLock entity = new HttpLock(url);
        Lockinfo body = new Lockinfo();
        Lockscope scopeType = new Lockscope();
        scopeType.setExclusive(new Exclusive());
        body.setLockscope(scopeType);
        Locktype lockType = new Locktype();
        lockType.setWrite(new Write());
        body.setLocktype(lockType);
        entity.setEntity(new StringEntity(SardineUtil.toXml(body), UTF_8));
        return this.execute(entity, new LockResponseHandler());
    }

    @Override
    public void unlock(String url, String token) throws IOException {
        HttpUnlock entity = new HttpUnlock(url, token);
        Lockinfo body = new Lockinfo();
        Lockscope scopeType = new Lockscope();
        scopeType.setExclusive(new Exclusive());
        body.setLockscope(scopeType);
        Locktype lockType = new Locktype();
        lockType.setWrite(new Write());
        body.setLocktype(lockType);
        this.execute(entity, new VoidResponseHandler());
    }

    @Override
    public InputStream get(String url) throws IOException {
        return this.get(url, Collections.<String, String>emptyMap());
    }

    @Override
    public InputStream get(String url, Map<String, String> headers) throws IOException {
        HttpGet get = new HttpGet(url);
        for (String header : headers.keySet()) {
            get.addHeader(header, headers.get(header));
        }
        HttpResponse response = this.execute(get);
        VoidResponseHandler handler = new VoidResponseHandler();
        try {
            handler.handleResponse(response);
            return new ConsumingInputStream(response);
        }
        catch (IOException ex) {
            get.abort();
            throw ex;
        }
    }

    @Override
    public void put(String url, byte[] data) throws IOException {
        this.put(url, data, null);
    }

    @Override
    public void put(String url, byte[] data, String contentType) throws IOException {
        ByteArrayEntity entity = new ByteArrayEntity(data);
        this.put(url, entity, contentType, true);
    }

    @Override
    public void put(String url, InputStream dataStream) throws IOException {
        this.put(url, dataStream, (String)null);
    }

    @Override
    public void put(String url, InputStream dataStream, String contentType) throws IOException {
        this.put(url, dataStream, contentType, true);
    }

    @Override
    public void put(String url, InputStream dataStream, String contentType, boolean expectContinue) throws IOException {
        InputStreamEntity entity = new InputStreamEntity(dataStream, -1L);
        this.put(url, entity, contentType, expectContinue);
    }

    @Override
    public void put(String url, InputStream dataStream, Map<String, String> headers) throws IOException {
        InputStreamEntity entity = new InputStreamEntity(dataStream, -1L);
        this.put(url, entity, headers);
    }

    public void put(String url, HttpEntity entity, String contentType, boolean expectContinue) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (contentType != null) {
            headers.put("Content-Type", contentType);
        }
        if (expectContinue) {
            headers.put("Expect", "100-continue");
        }
        this.put(url, entity, headers);
    }

    public void put(String url, HttpEntity entity, Map<String, String> headers) throws IOException {
        HttpPut put = new HttpPut(url);
        put.setEntity(entity);
        for (String header : headers.keySet()) {
            put.addHeader(header, headers.get(header));
        }
        if (!put.containsHeader("Content-Type")) {
            put.addHeader("Content-Type", "application/octet-stream");
        }
        try {
            this.execute(put, new VoidResponseHandler());
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 417) {
                put.removeHeaders("Expect");
                if (entity.isRepeatable()) {
                    this.execute(put, new VoidResponseHandler());
                    return;
                }
            }
            throw e;
        }
    }

    @Override
    public void delete(String url) throws IOException {
        HttpDelete delete = new HttpDelete(url);
        this.execute(delete, new VoidResponseHandler());
    }

    @Override
    public void move(String sourceUrl, String destinationUrl) throws IOException {
        HttpMove move = new HttpMove(sourceUrl, destinationUrl);
        this.execute(move, new VoidResponseHandler());
    }

    @Override
    public void copy(String sourceUrl, String destinationUrl) throws IOException {
        HttpCopy copy = new HttpCopy(sourceUrl, destinationUrl);
        this.execute(copy, new VoidResponseHandler());
    }

    @Override
    public void createDirectory(String url) throws IOException {
        HttpMkCol mkcol = new HttpMkCol(url);
        this.execute(mkcol, new VoidResponseHandler());
    }

    @Override
    public boolean exists(String url) throws IOException {
        HttpHead head = new HttpHead(url);
        return this.execute(head, new ExistsResponseHandler());
    }

    protected <T> T execute(HttpRequestBase request, ResponseHandler<T> responseHandler) throws IOException {
        try {
            return this.client.execute(request, responseHandler, this.context);
        }
        catch (IOException e) {
            request.abort();
            throw e;
        }
    }

    protected HttpResponse execute(HttpRequestBase request) throws IOException {
        try {
            return this.client.execute((HttpUriRequest)request, this.context);
        }
        catch (IOException e) {
            request.abort();
            throw e;
        }
    }

    protected AbstractHttpClient createDefaultClient(ProxySelector selector) {
        SchemeRegistry schemeRegistry = this.createDefaultSchemeRegistry();
        ClientConnectionManager cm = this.createDefaultConnectionManager(schemeRegistry);
        HttpParams params = this.createDefaultHttpParams();
        DefaultHttpClient client = new DefaultHttpClient(cm, params);
        client.setRoutePlanner(this.createDefaultRoutePlanner(schemeRegistry, selector));
        return client;
    }

    protected HttpParams createDefaultHttpParams() {
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion(params, HttpVersion.HTTP_1_1);
        String version = Version.getSpecification();
        if (version == null) {
            version = "UNAVAILABLE";
        }
        HttpProtocolParams.setUserAgent(params, "Sardine/" + version);
        HttpProtocolParams.setUseExpectContinue(params, false);
        HttpProtocolParams.setVersion(params, HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset(params, "ISO-8859-1");
        HttpConnectionParams.setTcpNoDelay(params, true);
        HttpConnectionParams.setSocketBufferSize(params, 8192);
        return params;
    }

    protected SchemeRegistry createDefaultSchemeRegistry() {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, this.createDefaultSocketFactory()));
        registry.register(new Scheme("https", 443, this.createDefaultSecureSocketFactory()));
        return registry;
    }

    protected PlainSocketFactory createDefaultSocketFactory() {
        return PlainSocketFactory.getSocketFactory();
    }

    protected SSLSocketFactory createDefaultSecureSocketFactory() {
        return SSLSocketFactory.getSocketFactory();
    }

    protected ClientConnectionManager createDefaultConnectionManager(SchemeRegistry schemeRegistry) {
        return new ThreadSafeClientConnManager(schemeRegistry);
    }

    protected HttpRoutePlanner createDefaultRoutePlanner(SchemeRegistry schemeRegistry, ProxySelector selector) {
        return new ProxySelectorRoutePlanner(schemeRegistry, selector);
    }
}

