/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sardine;

import com.googlecode.sardine.model.Creationdate;
import com.googlecode.sardine.model.Getcontentlength;
import com.googlecode.sardine.model.Getcontenttype;
import com.googlecode.sardine.model.Getetag;
import com.googlecode.sardine.model.Getlastmodified;
import com.googlecode.sardine.model.Propstat;
import com.googlecode.sardine.model.Resourcetype;
import com.googlecode.sardine.model.Response;
import com.googlecode.sardine.util.SardineUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DavResource {
    private static Logger log = LoggerFactory.getLogger(DavResource.class);
    public static final String DEFAULT_CONTENT_TYPE = "application/octetstream";
    public static final long DEFAULT_CONTENT_LENGTH = -1L;
    public static final String HTTPD_UNIX_DIRECTORY_CONTENT_TYPE = "httpd/unix-directory";
    private static final String SEPARATOR = "/";
    private final URI href;
    private final Date creation;
    private final Date modified;
    private final String contentType;
    private final String etag;
    private final Long contentLength;
    private final Map<String, String> customProps;

    protected DavResource(String href, Date creation, Date modified, String contentType, Long contentLength, String etag, Map<String, String> customProps) throws URISyntaxException {
        this.href = new URI(href);
        this.creation = creation;
        this.modified = modified;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.etag = etag;
        this.customProps = customProps;
    }

    public DavResource(Response response) throws URISyntaxException {
        this.href = new URI(response.getHref().get(0));
        this.creation = SardineUtil.parseDate(this.getCreationDate(response));
        this.modified = SardineUtil.parseDate(this.getModifiedDate(response));
        this.contentType = this.getContentType(response);
        this.contentLength = this.getContentLength(response);
        this.etag = this.getEtag(response);
        this.customProps = this.getCustomProps(response);
    }

    private String getModifiedDate(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            Getlastmodified glm = propstat.getProp().getGetlastmodified();
            if (glm == null || glm.getContent().size() != 1) continue;
            return glm.getContent().get(0);
        }
        return null;
    }

    private String getCreationDate(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            Creationdate gcd = propstat.getProp().getCreationdate();
            if (gcd == null || gcd.getContent().size() != 1) continue;
            return gcd.getContent().get(0);
        }
        return null;
    }

    private String getContentType(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            Resourcetype resourcetype = propstat.getProp().getResourcetype();
            if (resourcetype != null && resourcetype.getCollection() != null) {
                return HTTPD_UNIX_DIRECTORY_CONTENT_TYPE;
            }
            Getcontenttype gtt = propstat.getProp().getGetcontenttype();
            if (gtt == null || gtt.getContent().size() != 1) continue;
            return gtt.getContent().get(0);
        }
        return DEFAULT_CONTENT_TYPE;
    }

    private long getContentLength(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return -1L;
        }
        for (Propstat propstat : list) {
            Getcontentlength gcl = propstat.getProp().getGetcontentlength();
            if (gcl == null || gcl.getContent().size() != 1) continue;
            try {
                return Long.parseLong(gcl.getContent().get(0));
            }
            catch (NumberFormatException e) {
                log.warn(String.format("Failed to parse content length %s", gcl.getContent().get(0)));
            }
        }
        return -1L;
    }

    private String getEtag(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            Getetag etag = propstat.getProp().getGetetag();
            if (etag == null || etag.getContent().size() != 1) continue;
            return etag.getContent().get(0);
        }
        return null;
    }

    private Map<String, String> getCustomProps(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        HashMap<String, String> customPropsMap = new HashMap<String, String>();
        for (Propstat propstat : list) {
            List<Element> props = propstat.getProp().getAny();
            for (Element element : props) {
                customPropsMap.put(element.getLocalName(), element.getTextContent());
            }
        }
        return customPropsMap;
    }

    public Date getCreation() {
        return this.creation;
    }

    public Date getModified() {
        return this.modified;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public String getEtag() {
        return this.etag;
    }

    public boolean isDirectory() {
        return HTTPD_UNIX_DIRECTORY_CONTENT_TYPE.equals(this.contentType);
    }

    public Map<String, String> getCustomProps() {
        return this.customProps;
    }

    public URI getHref() {
        return this.href;
    }

    public String getName() {
        String path = this.href.getPath();
        try {
            if (path.endsWith(SEPARATOR)) {
                path = path.substring(0, path.length() - 1);
            }
            return path.substring(path.lastIndexOf(47) + 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            log.warn(String.format("Failed to parse name from path %s", path));
            return null;
        }
    }

    public String getPath() {
        return this.href.getPath();
    }

    public String toString() {
        return this.getPath();
    }
}

