/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.common.batchprocessing.product;

import java.math.BigDecimal;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.utils.ConvertDevise;
import org.openconcerto.modules.common.batchprocessing.ReferenceProcessor;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;

public class TVAProcessor
extends ReferenceProcessor {
    public TVAProcessor(SQLField field) {
        super(field);
    }

    @Override
    public void processBeforeUpdate(SQLRowAccessor from, SQLRowValues to) {
        SQLRow r = from.asRow();
        BigDecimal taux = BigDecimal.valueOf(TaxeCache.getCache().getTauxFromId(to.getForeignID("ID_TAXE")).floatValue());
        BigDecimal ht = r.getBigDecimal("PV_HT");
        BigDecimal ttc = ConvertDevise.getTtcFromHt((BigDecimal)ht, (BigDecimal)taux, (int)r.getTable().getField("PV_TTC").getType().getDecimalDigits());
        to.put("PV_TTC", (Object)ttc);
    }
}

