/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.common.batchprocessing.product;

import java.math.BigDecimal;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.utils.ConvertDevise;
import org.openconcerto.modules.common.batchprocessing.NumberProcessor;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;

public class TTCProcessor
extends NumberProcessor {
    public TTCProcessor(SQLField field) {
        super(field);
    }

    @Override
    public void processBeforeUpdate(SQLRowAccessor from, SQLRowValues to) {
        SQLRow r = from.asRow();
        BigDecimal taux = BigDecimal.valueOf(TaxeCache.getCache().getTauxFromId(r.getForeignID("ID_TAXE")).floatValue());
        BigDecimal ttc = to.getBigDecimal("PV_TTC");
        BigDecimal ht = ConvertDevise.getHtFromTtc((BigDecimal)ttc, (BigDecimal)taux, (int)from.getTable().getField("PV_HT").getType().getDecimalDigits());
        to.put("PV_HT", (Object)ht);
        to.put("PRIX_METRIQUE_VT_1", (Object)ht);
    }
}

