/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.common.batchprocessing.product;

import java.math.BigDecimal;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.utils.ConvertDevise;
import org.openconcerto.modules.common.batchprocessing.NumberProcessor;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;

public class HTProcessor
extends NumberProcessor {
    public HTProcessor(SQLField field) {
        super(field);
    }

    @Override
    public void processBeforeUpdate(SQLRowAccessor from, SQLRowValues to) {
        SQLRow r = from.asRow();
        BigDecimal taux = BigDecimal.valueOf(TaxeCache.getCache().getTauxFromId(r.getForeignID("ID_TAXE")).floatValue());
        BigDecimal ht = to.getBigDecimal("PV_HT");
        BigDecimal ttc = ConvertDevise.getTtcFromHt((BigDecimal)ht, (BigDecimal)taux, (int)from.getTable().getField("PV_TTC").getType().getDecimalDigits());
        to.put("PV_TTC", (Object)ttc);
        to.put("PRIX_METRIQUE_VT_1", (Object)ht);
    }
}

