/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.common.batchprocessing;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.openconcerto.modules.common.batchprocessing.BatchProcessor;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class StringProcessor
extends JPanel
implements BatchProcessor {
    private final SQLField field;
    final JTextField tReplace = new JTextField();
    private JRadioButton bReplace;
    final JTextField tPrefix = new JTextField();
    private JRadioButton bPrefix;
    final JTextField tSuffix = new JTextField();
    private JRadioButton bSuffix;
    private JRadioButton bLower;
    private JRadioButton bUpper;

    public StringProcessor(SQLField field) {
        this.field = field;
        this.setLayout(new GridBagLayout());
        this.bReplace = new JRadioButton("remplacer par");
        this.bPrefix = new JRadioButton("pr\u00e9fixer par");
        this.bSuffix = new JRadioButton("suffixer par");
        this.bLower = new JRadioButton("mettre en minuscule");
        this.bUpper = new JRadioButton("mettre en majuscule");
        ButtonGroup group = new ButtonGroup();
        group.add(this.bReplace);
        group.add(this.bPrefix);
        group.add(this.bSuffix);
        group.add(this.bLower);
        group.add(this.bUpper);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.add((Component)this.bReplace, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.tReplace, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)this.bPrefix, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.tPrefix, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)this.bSuffix, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.tSuffix, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 2;
        this.add((Component)this.bLower, c);
        ++c.gridy;
        this.add((Component)this.bUpper, c);
        this.tPrefix.setEnabled(false);
        this.tSuffix.setEnabled(false);
        group.setSelected(this.bReplace.getModel(), true);
        this.bLower.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringProcessor.this.tPrefix.setEnabled(false);
                StringProcessor.this.tReplace.setEnabled(false);
                StringProcessor.this.tSuffix.setEnabled(false);
            }
        });
        this.bUpper.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringProcessor.this.tPrefix.setEnabled(false);
                StringProcessor.this.tReplace.setEnabled(false);
                StringProcessor.this.tSuffix.setEnabled(false);
            }
        });
        this.bPrefix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringProcessor.this.tPrefix.setEnabled(true);
                StringProcessor.this.tReplace.setEnabled(false);
                StringProcessor.this.tSuffix.setEnabled(false);
            }
        });
        this.bSuffix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringProcessor.this.tPrefix.setEnabled(false);
                StringProcessor.this.tReplace.setEnabled(false);
                StringProcessor.this.tSuffix.setEnabled(true);
            }
        });
        this.bReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringProcessor.this.tPrefix.setEnabled(false);
                StringProcessor.this.tReplace.setEnabled(true);
                StringProcessor.this.tSuffix.setEnabled(false);
            }
        });
    }

    @Override
    public void process(List<SQLRowValues> r) throws SQLException {
        block10: {
            block13: {
                block12: {
                    block11: {
                        block9: {
                            if (!this.bReplace.isSelected()) break block9;
                            String string = this.ensureSize(this.tReplace.getText());
                            for (SQLRowAccessor sQLRowAccessor : r) {
                                SQLRowValues rowValues = sQLRowAccessor.createEmptyUpdateRow();
                                rowValues.put(this.field.getName(), (Object)string);
                                this.processBeforeUpdate(sQLRowAccessor, rowValues);
                                rowValues.update();
                            }
                            break block10;
                        }
                        if (!this.bPrefix.isSelected()) break block11;
                        String string = this.tPrefix.getText();
                        for (SQLRowAccessor sQLRowAccessor : r) {
                            SQLRowValues rowValues = sQLRowAccessor.createEmptyUpdateRow();
                            String str = sQLRowAccessor.asRow().getString(this.field.getName());
                            if (str == null) {
                                str = "";
                            }
                            rowValues.put(this.field.getName(), (Object)this.ensureSize(String.valueOf(string) + str));
                            this.processBeforeUpdate(sQLRowAccessor, rowValues);
                            rowValues.update();
                        }
                        break block10;
                    }
                    if (!this.bSuffix.isSelected()) break block12;
                    String string = this.tSuffix.getText();
                    for (SQLRowAccessor sQLRowAccessor : r) {
                        SQLRowValues rowValues = sQLRowAccessor.createEmptyUpdateRow();
                        String str = sQLRowAccessor.asRow().getString(this.field.getName());
                        if (str == null) {
                            str = "";
                        }
                        rowValues.put(this.field.getName(), (Object)this.ensureSize(String.valueOf(str) + string));
                        this.processBeforeUpdate(sQLRowAccessor, rowValues);
                        rowValues.update();
                    }
                    break block10;
                }
                if (!this.bLower.isSelected()) break block13;
                for (SQLRowAccessor sQLRowAccessor : r) {
                    String str = sQLRowAccessor.asRow().getString(this.field.getName());
                    if (str == null) {
                        str = "";
                    }
                    SQLRowValues rowValues = sQLRowAccessor.createEmptyUpdateRow();
                    rowValues.put(this.field.getName(), (Object)str.toLowerCase());
                    this.processBeforeUpdate(sQLRowAccessor, rowValues);
                    rowValues.update();
                }
                break block10;
            }
            if (!this.bUpper.isSelected()) break block10;
            for (SQLRowAccessor sQLRowAccessor : r) {
                String str = sQLRowAccessor.asRow().getString(this.field.getName());
                if (str == null) {
                    str = "";
                }
                SQLRowValues rowValues = sQLRowAccessor.createEmptyUpdateRow();
                rowValues.put(this.field.getName(), (Object)str.toUpperCase());
                this.processBeforeUpdate(sQLRowAccessor, rowValues);
                rowValues.update();
            }
        }
    }

    private String ensureSize(String text) {
        if (text.length() < this.field.getType().getSize()) {
            return text;
        }
        return text.substring(0, this.field.getType().getSize());
    }

    @Override
    public boolean checkParameters() {
        if (this.bReplace.isSelected()) {
            return true;
        }
        if (this.bPrefix.isSelected()) {
            return !this.tPrefix.getText().isEmpty();
        }
        if (this.bSuffix.isSelected()) {
            return !this.bPrefix.getText().isEmpty();
        }
        return true;
    }

    @Override
    public void processBeforeUpdate(SQLRowAccessor from, SQLRowValues to) {
    }
}

