/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.common.batchprocessing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.modules.common.batchprocessing.BatchProcessor;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.warning.JLabelWarning;

public class ReferenceProcessor
extends JPanel
implements BatchProcessor {
    private final SQLField field;
    final SQLElement element;
    private ElementComboBox combo;

    public ReferenceProcessor(SQLField field) {
        this.field = field;
        this.element = ComptaPropsConfiguration.getInstanceCompta().getDirectory().getElement(field.getForeignTable());
        if (this.element != null) {
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel("remplacer par "), "West");
            this.combo = new ElementComboBox(true, 200);
            this.combo.setMinimal();
            this.combo.setAddIconVisible(false);
            this.combo.init(this.element);
            this.add((Component)this.combo, "Center");
        } else {
            this.setLayout(new FlowLayout());
            this.add((Component)new JLabelWarning("No element for table " + field.getTable().getName()));
        }
    }

    @Override
    public void process(List<SQLRowValues> r) throws SQLException {
        for (SQLRowAccessor sQLRowAccessor : r) {
            SQLRowValues rowValues = sQLRowAccessor.createEmptyUpdateRow();
            rowValues.put(this.field.getName(), this.combo.getSelectedId());
            this.processBeforeUpdate(sQLRowAccessor, rowValues);
            rowValues.update();
        }
    }

    @Override
    public boolean checkParameters() {
        return this.element != null;
    }

    @Override
    public void processBeforeUpdate(SQLRowAccessor from, SQLRowValues to) {
    }
}

