/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.common.batchprocessing;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.openconcerto.modules.common.batchprocessing.BatchProcessor;
import org.openconcerto.modules.common.batchprocessing.DecimalOrPercentVerifier;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class NumberProcessor
extends JPanel
implements BatchProcessor {
    private final SQLField field;
    final JTextField tReplace = new JTextField();
    private JRadioButton bReplace;
    final JTextField tAdd = new JTextField();
    private JRadioButton bAdd;
    final JTextField tRemove = new JTextField();
    private JRadioButton bRemove;

    public NumberProcessor(SQLField field) {
        this.field = field;
        this.setLayout(new GridBagLayout());
        this.bReplace = new JRadioButton("remplacer par");
        this.bAdd = new JRadioButton("augmenter de");
        this.bRemove = new JRadioButton("diminuer de");
        ButtonGroup group = new ButtonGroup();
        group.add(this.bReplace);
        group.add(this.bAdd);
        group.add(this.bRemove);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.add((Component)this.bReplace, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.tReplace, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)this.bAdd, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.tAdd, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)this.bRemove, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.tRemove, c);
        this.tAdd.setEnabled(false);
        this.tRemove.setEnabled(false);
        this.tAdd.setInputVerifier(new DecimalOrPercentVerifier());
        this.tRemove.setInputVerifier(new DecimalOrPercentVerifier());
        group.setSelected(this.bReplace.getModel(), true);
        this.bReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberProcessor.this.tReplace.setEnabled(true);
                NumberProcessor.this.tAdd.setEnabled(false);
                NumberProcessor.this.tRemove.setEnabled(false);
            }
        });
        this.bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberProcessor.this.tReplace.setEnabled(false);
                NumberProcessor.this.tAdd.setEnabled(true);
                NumberProcessor.this.tRemove.setEnabled(false);
            }
        });
        this.bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberProcessor.this.tReplace.setEnabled(false);
                NumberProcessor.this.tAdd.setEnabled(false);
                NumberProcessor.this.tRemove.setEnabled(true);
            }
        });
    }

    @Override
    public void process(List<SQLRowValues> r) throws SQLException {
        block10: {
            boolean bl;
            block11: {
                boolean bl2;
                block9: {
                    if (!this.bReplace.isSelected()) break block9;
                    BigDecimal v = new BigDecimal(this.tReplace.getText().trim());
                    for (SQLRowAccessor sQLRowAccessor : r) {
                        SQLRowValues sQLRowValues = sQLRowAccessor.createEmptyUpdateRow();
                        sQLRowValues.put(this.field.getName(), this.decimalToFieldType(v));
                        this.processBeforeUpdate(sQLRowAccessor, sQLRowValues);
                        sQLRowValues.update();
                    }
                    break block10;
                }
                if (!this.bAdd.isSelected()) break block11;
                String t = this.tAdd.getText().trim();
                boolean bl3 = false;
                if (t.endsWith("%")) {
                    t = t.substring(0, t.length() - 1);
                    bl2 = true;
                }
                BigDecimal v = new BigDecimal(t);
                for (SQLRowAccessor sQLRowAccessor : r) {
                    SQLRowValues rowValues = sQLRowAccessor.createEmptyUpdateRow();
                    BigDecimal value = sQLRowAccessor.asRow().getBigDecimal(this.field.getName());
                    if (value == null) continue;
                    if (bl2) {
                        rowValues.put(this.field.getName(), this.decimalToFieldType(value.multiply(v.divide(new BigDecimal(100)).add(BigDecimal.ONE))));
                    } else {
                        rowValues.put(this.field.getName(), this.decimalToFieldType(value.add(v)));
                    }
                    this.processBeforeUpdate(sQLRowAccessor, rowValues);
                    rowValues.update();
                }
                break block10;
            }
            if (!this.bRemove.isSelected()) break block10;
            String t = this.tRemove.getText().trim();
            boolean bl4 = false;
            if (t.endsWith("%")) {
                t = t.substring(0, t.length() - 1);
                bl = true;
            }
            BigDecimal v = new BigDecimal(t);
            for (SQLRowAccessor sQLRowAccessor : r) {
                SQLRowValues rowValues = sQLRowAccessor.createEmptyUpdateRow();
                BigDecimal value = sQLRowAccessor.asRow().getBigDecimal(this.field.getName());
                if (value == null) continue;
                if (bl) {
                    rowValues.put(this.field.getName(), this.decimalToFieldType(value.multiply(v.divide(new BigDecimal(-100)).add(BigDecimal.ONE))));
                } else {
                    rowValues.put(this.field.getName(), this.decimalToFieldType(value.add(v)));
                }
                this.processBeforeUpdate(sQLRowAccessor, rowValues);
                rowValues.update();
            }
        }
    }

    private Object decimalToFieldType(BigDecimal v) {
        Class javaType = this.field.getType().getJavaType();
        if (javaType.equals(BigDecimal.class)) {
            return v;
        }
        if (javaType.equals(Float.class)) {
            return Float.valueOf(v.floatValue());
        }
        if (javaType.equals(Double.class)) {
            return v.doubleValue();
        }
        if (javaType.equals(Integer.class)) {
            return v.intValue();
        }
        if (javaType.equals(Long.class)) {
            return v.longValue();
        }
        return v;
    }

    @Override
    public boolean checkParameters() {
        if (this.bReplace.isSelected()) {
            try {
                BigDecimal v = new BigDecimal(this.tReplace.getText().trim());
                return v != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (this.bAdd.isSelected()) {
            return this.tAdd.getInputVerifier().verify(this.tAdd);
        }
        if (this.bRemove.isSelected()) {
            return this.tRemove.getInputVerifier().verify(this.tRemove);
        }
        return false;
    }

    @Override
    public void processBeforeUpdate(SQLRowAccessor from, SQLRowValues to) {
    }
}

