/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.common.batchprocessing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.ComponentsContext;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.modules.ModulePackager;
import org.openconcerto.erp.modules.RuntimeModuleFactory;
import org.openconcerto.modules.common.batchprocessing.BatchEditorPanel;
import org.openconcerto.modules.common.batchprocessing.FieldFilter;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRequestLog;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.FrameUtil;

public final class Module
extends AbstractModule {
    public Module(ModuleFactory f) throws IOException {
        super(f);
    }

    protected void setupComponents(ComponentsContext ctxt) {
        super.setupComponents(ctxt);
        final SQLElement element = ctxt.getElement("ARTICLE");
        RowAction.PredicateRowAction editAction = new RowAction.PredicateRowAction(new AbstractAction("Traitement par lot..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                List rows = IListe.get((EventObject)e).getSelectedRows();
                int size = rows.size();
                if (size > 0) {
                    JFrame f = new JFrame();
                    if (size > 1) {
                        f.setTitle("Traitement des " + size + " " + element.getPluralName());
                    } else {
                        f.setTitle("Traitement d'" + element.getSingularName());
                    }
                    FieldFilter filter = new FieldFilter(){

                        @Override
                        public boolean isFiltered(SQLField f) {
                            String fieldName = f.getName();
                            return fieldName.contains("METRIQUE") || fieldName.equals("ID_STOCK");
                        }
                    };
                    f.setContentPane(new BatchEditorPanel(rows, filter));
                    f.pack();
                    f.setMinimumSize(new Dimension(400, 300));
                    f.setLocationRelativeTo((Component)IListe.get((EventObject)e));
                    FrameUtil.show((Window)f);
                }
            }
        }, false){};
        editAction.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        element.getRowActions().add(editAction);
    }

    protected void start() {
    }

    protected void stop() {
    }

    public static void main(String[] args) throws IOException {
        System.setProperty("org.openconcerto.quickLogin", "true");
        File propsFile = new File("module.properties");
        RuntimeModuleFactory factory = new RuntimeModuleFactory(propsFile);
        SQLRequestLog.setEnabled((boolean)true);
        SQLRequestLog.showFrame();
        ModulePackager modulePackager = new ModulePackager(propsFile, new File("bin/"));
        modulePackager.writeToDir(new File("../OpenConcerto/Modules"));
        ModuleManager.getInstance().addFactories(new File("../OpenConcerto/Modules"));
        ModuleManager.getInstance().addFactoryAndStart((ModuleFactory)factory, false);
        Gestion.main((String[])args);
    }
}

