/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.common.batchprocessing;

import java.awt.Component;
import java.awt.FlowLayout;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.modules.common.batchprocessing.BatchProcessor;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.ui.JDate;

public class DateProcessor
extends JPanel
implements BatchProcessor {
    private final JDate d = new JDate(true);
    private final SQLField field;

    public DateProcessor(SQLField field) {
        this.field = field;
        this.setLayout(new FlowLayout());
        this.add(new JLabel("forcer la date au "));
        this.add((Component)this.d);
    }

    @Override
    public void process(List<SQLRowValues> r) throws SQLException {
        Date date = this.d.getDate();
        for (SQLRowAccessor sQLRowAccessor : r) {
            SQLRowValues rowValues = sQLRowAccessor.createEmptyUpdateRow();
            rowValues.put(this.field.getName(), (Object)date);
            this.processBeforeUpdate(sQLRowAccessor, rowValues);
            rowValues.update();
        }
    }

    @Override
    public boolean checkParameters() {
        Date date = this.d.getDate();
        return date != null || this.field.isNullable() != false;
    }

    @Override
    public void processBeforeUpdate(SQLRowAccessor from, SQLRowValues to) {
    }
}

