/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.common.batchprocessing;

import java.awt.LayoutManager;
import java.sql.SQLException;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openconcerto.modules.common.batchprocessing.BatchProcessor;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.ui.VFlowLayout;

public class BooleanProcessor
extends JPanel
implements BatchProcessor {
    private final SQLField field;
    private JRadioButton bTrue;
    private JRadioButton bFalse;
    private JRadioButton bInvert;

    public BooleanProcessor(SQLField field) {
        this.field = field;
        this.setLayout((LayoutManager)new VFlowLayout());
        this.bTrue = new JRadioButton("forcer \u00e0 vrai");
        this.bFalse = new JRadioButton("forcer \u00e0 faux");
        this.bInvert = new JRadioButton("inverser");
        ButtonGroup group = new ButtonGroup();
        group.add(this.bTrue);
        group.add(this.bFalse);
        group.add(this.bInvert);
        this.add(this.bTrue);
        this.add(this.bFalse);
        this.add(this.bInvert);
        group.setSelected(this.bTrue.getModel(), true);
    }

    @Override
    public void process(List<SQLRowValues> r) throws SQLException {
        block4: {
            block5: {
                block3: {
                    if (!this.bTrue.isSelected()) break block3;
                    for (SQLRowAccessor sQLRowAccessor : r) {
                        SQLRowValues rowValues = sQLRowAccessor.createEmptyUpdateRow();
                        rowValues.put(this.field.getName(), (Object)Boolean.TRUE);
                        this.processBeforeUpdate(sQLRowAccessor, rowValues);
                        rowValues.update();
                    }
                    break block4;
                }
                if (!this.bFalse.isSelected()) break block5;
                for (SQLRowAccessor sQLRowAccessor : r) {
                    SQLRowValues rowValues = sQLRowAccessor.createEmptyUpdateRow();
                    rowValues.put(this.field.getName(), (Object)Boolean.FALSE);
                    this.processBeforeUpdate(sQLRowAccessor, rowValues);
                    rowValues.update();
                }
                break block4;
            }
            if (!this.bInvert.isSelected()) break block4;
            for (SQLRowAccessor sQLRowAccessor : r) {
                SQLRowValues rowValues = sQLRowAccessor.createEmptyUpdateRow();
                Boolean boolean1 = sQLRowAccessor.asRow().getBoolean(this.field.getName());
                if (boolean1 == null) continue;
                rowValues.put(this.field.getName(), (Object)boolean1.equals(Boolean.FALSE));
                this.processBeforeUpdate(sQLRowAccessor, rowValues);
                rowValues.update();
            }
        }
    }

    @Override
    public boolean checkParameters() {
        return true;
    }

    @Override
    public void processBeforeUpdate(SQLRowAccessor from, SQLRowValues to) {
    }
}

