/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.common.batchprocessing;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.openconcerto.modules.common.batchprocessing.BatchDetailPanel;
import org.openconcerto.modules.common.batchprocessing.BatchProcessor;
import org.openconcerto.modules.common.batchprocessing.FieldFilter;
import org.openconcerto.modules.common.batchprocessing.ForbiddenFieldName;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.ReloadPanel;
import org.openconcerto.utils.ExceptionHandler;

public class BatchEditorPanel
extends JPanel {
    public BatchEditorPanel(final List<SQLRowValues> rows, FieldFilter filter) {
        Configuration conf = PropsConfiguration.getInstance();
        final SQLFieldTranslator translator = conf.getTranslator();
        Set fields = rows.get(0).getTable().getFields();
        ArrayList<SQLField> f = new ArrayList<SQLField>();
        for (SQLField sqlField : fields) {
            if (!ForbiddenFieldName.isAllowed(sqlField.getName()) || translator.getLabelFor(sqlField) == null || filter != null && filter.isFiltered(sqlField)) continue;
            f.add(sqlField);
        }
        Collections.sort(f, new Comparator<SQLField>(){

            @Override
            public int compare(SQLField o1, SQLField o2) {
                return translator.getLabelFor(o1).compareToIgnoreCase(translator.getLabelFor(o2));
            }
        });
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.add((Component)new JLabel("Champ"), c);
        final JComboBox<SQLField> combo = new JComboBox<SQLField>(f.toArray(new SQLField[1]));
        combo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String label = translator.getLabelFor((SQLField)value);
                return super.getListCellRendererComponent((JList<?>)list, label, index, isSelected, cellHasFocus);
            }
        });
        combo.setSelectedIndex(0);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        this.add(combo, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.fill = 2;
        this.add((Component)new JLabelBold("Action \u00e0 appliquer"), c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        ++c.gridy;
        c.anchor = 18;
        final BatchDetailPanel comp = new BatchDetailPanel();
        comp.setField((SQLField)combo.getSelectedItem());
        this.add((Component)comp, c);
        JPanel actions = new JPanel();
        actions.setLayout(new FlowLayout(2));
        final JButton buttonProcess = new JButton("Lancer le traitement");
        final JButton buttonCancel = new JButton("Annuler");
        final ReloadPanel reload = new ReloadPanel();
        actions.add((Component)reload);
        actions.add(buttonProcess);
        actions.add(buttonCancel);
        ++c.gridy;
        c.weighty = 0.0;
        this.add((Component)actions, c);
        combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                comp.setField((SQLField)combo.getSelectedItem());
            }
        });
        buttonProcess.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!comp.getProcessor().checkParameters()) {
                    JOptionPane.showMessageDialog(BatchEditorPanel.this, "Param\u00e8tres non valides");
                    return;
                }
                buttonProcess.setEnabled(false);
                buttonCancel.setEnabled(false);
                comp.setEnabled(false);
                combo.setEnabled(false);
                reload.setMode(0);
                SwingWorker<Object, Object> w = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        try {
                            BatchProcessor processor = comp.getProcessor();
                            processor.process(rows);
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle((String)"Echec du traitement", (Throwable)e);
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        reload.setMode(2);
                        JOptionPane.showMessageDialog(BatchEditorPanel.this, "Traitement termin\u00e9");
                        SwingUtilities.getWindowAncestor(BatchEditorPanel.this).dispose();
                    }
                };
                w.execute();
            }
        });
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.getWindowAncestor(BatchEditorPanel.this).dispose();
            }
        });
    }
}

