/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.common.batchprocessing;

import java.awt.Component;
import java.awt.LayoutManager;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openconcerto.modules.common.batchprocessing.BatchProcessor;
import org.openconcerto.modules.common.batchprocessing.BooleanProcessor;
import org.openconcerto.modules.common.batchprocessing.DateProcessor;
import org.openconcerto.modules.common.batchprocessing.NumberProcessor;
import org.openconcerto.modules.common.batchprocessing.ReferenceProcessor;
import org.openconcerto.modules.common.batchprocessing.StringProcessor;
import org.openconcerto.modules.common.batchprocessing.product.HTProcessor;
import org.openconcerto.modules.common.batchprocessing.product.PurchaseProcessor;
import org.openconcerto.modules.common.batchprocessing.product.TTCProcessor;
import org.openconcerto.modules.common.batchprocessing.product.TVAProcessor;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.ui.VFlowLayout;

public class BatchDetailPanel
extends JPanel {
    private BatchProcessor processor;

    BatchDetailPanel() {
        this.setLayout((LayoutManager)new VFlowLayout());
    }

    public void setField(SQLField field) {
        this.removeAll();
        SQLType type = field.getType();
        Class javaType = type.getJavaType();
        String fName = field.getName();
        if (fName.equals("PV_TTC")) {
            TTCProcessor p = new TTCProcessor(field);
            this.add(p);
            this.processor = p;
        } else if (fName.equals("PV_HT")) {
            HTProcessor p = new HTProcessor(field);
            this.add(p);
            this.processor = p;
        } else if (fName.equals("ID_TAXE")) {
            TVAProcessor p = new TVAProcessor(field);
            this.add(p);
            this.processor = p;
        } else if (fName.equals("PA_HT")) {
            PurchaseProcessor p = new PurchaseProcessor(field);
            this.add(p);
            this.processor = p;
        } else if (javaType.equals(Boolean.class)) {
            BooleanProcessor p = new BooleanProcessor(field);
            this.add(p);
            this.processor = p;
        } else if (field.isKey()) {
            ReferenceProcessor p = new ReferenceProcessor(field);
            this.add(p);
            this.processor = p;
        } else if (javaType.equals(String.class)) {
            StringProcessor p = new StringProcessor(field);
            this.add(p);
            this.processor = p;
        } else if (javaType.equals(Date.class)) {
            DateProcessor p = new DateProcessor(field);
            this.add(p);
            this.processor = p;
        } else if (javaType.equals(BigDecimal.class) || javaType.equals(Float.class) || javaType.equals(Double.class) || javaType.equals(Integer.class) || javaType.equals(Long.class)) {
            NumberProcessor p = new NumberProcessor(field);
            this.add(p);
            this.processor = p;
        }
        this.revalidate();
        this.repaint();
    }

    public BatchProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.processor != null && this.processor instanceof JComponent) {
            Component[] l = ((JComponent)((Object)this.processor)).getComponents();
            int i = 0;
            while (i < l.length) {
                l[i].setEnabled(false);
                ++i;
            }
        }
        super.setEnabled(enabled);
    }
}

