/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.io;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.openconcerto.utils.NumberUtils;
import org.openconcerto.utils.XMLDateFormat;
import org.openconcerto.utils.io.HTMLable;
import org.openconcerto.utils.io.JSONAble;

public class JSONConverter {
    private static final Format DF = new XMLDateFormat();

    public static final <T> T fromJson(Gson gson, String json, TypeToken<T> typeOfT) {
        return gson.fromJson(json, typeOfT.getType());
    }

    public static final <T> T fromJson(Gson gson, JsonElement json, TypeToken<T> typeOfT) {
        return gson.fromJson(json, typeOfT.getType());
    }

    private static final synchronized String format(Date d) {
        return DF.format(d);
    }

    public static synchronized String formatCalendar(Calendar calendar) {
        return DF.format(calendar);
    }

    private static final synchronized Date parse(String s) throws java.text.ParseException {
        return (Date)DF.parseObject(s);
    }

    public static Object getJSON(Object param) {
        Object result = null;
        if (param != null) {
            if (param instanceof HTMLable) {
                result = ((HTMLable)param).getHTML();
            } else if (param instanceof JSONAble) {
                result = ((JSONAble)param).toJSON();
            } else if (param instanceof Date) {
                result = JSONConverter.format((Date)param);
            } else if (param instanceof Calendar) {
                result = JSONConverter.formatCalendar((Calendar)param);
            } else if (param instanceof Class) {
                result = ((Class)param).getName();
            } else if (param instanceof Iterable) {
                Iterable tmp = (Iterable)param;
                JSONArray jsonArray = new JSONArray();
                for (Object o : tmp) {
                    jsonArray.add(JSONConverter.getJSON(o));
                }
                result = jsonArray;
            } else if (param instanceof Color) {
                if (param != null) {
                    Color paramColor = (Color)param;
                    JSONObject jsonColor = new JSONObject();
                    jsonColor.put("r", paramColor.getRed());
                    jsonColor.put("g", paramColor.getGreen());
                    jsonColor.put("b", paramColor.getBlue());
                    result = jsonColor;
                }
            } else {
                result = param instanceof BigDecimal ? Double.valueOf(((BigDecimal)param).doubleValue()) : param;
            }
        }
        return result;
    }

    public static <T> T getObjectFromJSON(Object o, Class<T> type) {
        T result;
        if (o != null && !o.equals("null")) {
            if (type.isInstance(o)) {
                result = type.cast(o);
            } else if (type.equals(Integer.class)) {
                int intVal;
                if (o instanceof BigDecimal) {
                    intVal = ((BigDecimal)o).intValueExact();
                } else if (o instanceof BigInteger) {
                    BigInteger bigInt = (BigInteger)o;
                    if (bigInt.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0 || bigInt.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                        throw new IllegalArgumentException("object (" + o.getClass().getName() + ") is not assignable for '" + type + "'");
                    }
                    intVal = bigInt.intValue();
                } else {
                    try {
                        intVal = NumberUtils.ensureInt((Long)o);
                    }
                    catch (ArithmeticException ex) {
                        throw new IllegalArgumentException("object (" + o.getClass().getName() + ") is not assignable for '" + type + "'", ex);
                    }
                }
                result = type.cast(intVal);
            } else if (type.equals(Date.class)) {
                String sparam = (String)o;
                try {
                    Date c = JSONConverter.parse(sparam);
                    result = type.cast(c);
                }
                catch (java.text.ParseException e) {
                    throw new IllegalArgumentException("object (" + o.getClass().getName() + ") is not assignable for '" + type + "', the format is not valid", e);
                }
            } else if (type.equals(Color.class)) {
                JSONObject jsonColor = (JSONObject)o;
                int r = JSONConverter.getParameterFromJSON(jsonColor, "r", Integer.class);
                int g = JSONConverter.getParameterFromJSON(jsonColor, "g", Integer.class);
                int b = JSONConverter.getParameterFromJSON(jsonColor, "b", Integer.class);
                result = type.cast(new Color(r, g, b));
            } else {
                result = type.cast(o);
            }
        } else {
            result = null;
        }
        return result;
    }

    public static <T> T getParameterFromJSON(JSONObject json, String key, Class<T> type) {
        return JSONConverter.getParameterFromJSON(json, key, type, null);
    }

    public static <T> T getParameterFromJSON(JSONObject json, String key, Class<T> type, T defaultValue) {
        return json.containsKey(key) ? JSONConverter.getObjectFromJSON(json.get(key), type) : defaultValue;
    }

    public static JSONObject convertStringToJsonObject(String jsonString) {
        JSONObject json;
        JSONParser parser = new JSONParser(128);
        try {
            json = (JSONObject)parser.parse(jsonString);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        return json;
    }

    public static JSONArray convertStringToJsonArray(String jsonString) {
        JSONArray json;
        JSONParser parser = new JSONParser(128);
        try {
            json = (JSONArray)parser.parse(jsonString);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        return json;
    }
}

