/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.change;

import java.util.Collection;
import java.util.List;
import org.openconcerto.utils.change.CollectionChangeEvent;
import org.openconcerto.utils.change.IListDataEvent;

public abstract class CollectionChangeEventCreator {
    private final Object src;
    private final String propName;
    private final Collection oldVal;

    protected CollectionChangeEventCreator(Object src, String propName, Collection oldVal) {
        if (oldVal == null) {
            throw new NullPointerException();
        }
        this.src = src;
        this.propName = propName;
        this.oldVal = this.clone(oldVal);
        if (this.oldVal == oldVal) {
            throw new IllegalStateException("oldVal has not been cloned : " + oldVal + " == " + this.oldVal);
        }
        if (!this.oldVal.equals(oldVal)) {
            throw new IllegalStateException("clones are not equal : " + oldVal + " != " + this.oldVal);
        }
    }

    protected abstract Collection clone(Collection var1);

    public CollectionChangeEvent create(Collection newVal) {
        return new CollectionChangeEvent(this.src, this.propName, this.oldVal, this.clone(newVal));
    }

    public IListDataEvent create(List newVal, int type, int index0, int index1) {
        return new IListDataEvent(this.create(newVal), type, index0, index1);
    }

    public final Collection getOld() {
        return this.oldVal;
    }

    public final String getName() {
        return this.propName;
    }
}

