/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.openconcerto.utils.CopyUtils;

public abstract class AbstractMapDecorator<K, V>
implements Map<K, V>,
Cloneable {
    private Map<K, V> delegate;

    public AbstractMapDecorator(Map<K, V> delegate) {
        this.delegate = delegate;
    }

    protected final Map<K, V> getDelegate() {
        return this.delegate;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.delegate.toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        try {
            Map<K, V> delegate = CopyUtils.copy(this.delegate);
            AbstractMapDecorator res = (AbstractMapDecorator)super.clone();
            res.delegate = delegate;
            return res;
        }
        catch (CloneNotSupportedException e) {
            throw e;
        }
        catch (Exception e) {
            CloneNotSupportedException exn = new CloneNotSupportedException();
            exn.initCause(e);
            throw exn;
        }
    }
}

