/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.File;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.i18n.TM;

public final class SystemInfo {
    public static final String CLASS_PROTOCOL = "class";

    public static NavigableMap<Info, String> get(boolean html) {
        TreeMap<Info, String> res = new TreeMap<Info, String>();
        String lineBreak = SystemInfo.getLineBreak(html);
        String version = System.getProperty("java.runtime.version") != null ? System.getProperty("java.runtime.version") : System.getProperty("java.version");
        URI vendorURI = null;
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        URI lafURI = null;
        try {
            vendorURI = new URI(System.getProperty("java.vendor.url"));
            lafURI = new URI(CLASS_PROTOCOL, lookAndFeel.getClass().getName(), null);
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        Runtime rt = Runtime.getRuntime();
        String stats = "<i>" + TM.tr("memory", new Object[0]) + " :</i> " + SystemInfo.formatBytes(rt.freeMemory()) + " / " + SystemInfo.formatBytes(rt.totalMemory()) + " ; " + TM.tr("processors", rt.availableProcessors());
        String lafDesc = lookAndFeel == null ? TM.tr("no.laf", new Object[0]) : String.valueOf(SystemInfo.getLink(lookAndFeel.getName(), lafURI, html)) + ", " + lookAndFeel.getDescription();
        String p = String.valueOf(TM.tr("javaVersion", version, SystemInfo.getLink(System.getProperty("java.vendor"), vendorURI, html))) + " ; " + SystemInfo.getLink(TM.tr("javaHome", new Object[0]), new File(System.getProperty("java.home")).toURI(), html) + lineBreak + stats + lineBreak + lafDesc;
        res.put(Info.JAVA, p);
        res.put(Info.OS, "<b>" + System.getProperty("os.name") + "</b> " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
        res.put(Info.USER, String.valueOf(System.getProperty("user.name")) + " ; " + SystemInfo.getLink(TM.tr("home.dir", new Object[0]), new File(System.getProperty("user.home")).toURI(), html) + " ; " + SystemInfo.getLink(TM.tr("cwd", new Object[0]), new File(System.getProperty("user.dir")).toURI(), html));
        ArrayList<String> ifs = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface ni = en.nextElement();
                if (ni.getHardwareAddress() == null || ni.isLoopback() || ni.getDisplayName().toLowerCase().contains("vmware") || ni.getName().toLowerCase().contains("vmnet")) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(String.valueOf(ni.getName()) + " " + CollectionUtils.join(ni.getInterfaceAddresses(), ", ", new ITransformer<InterfaceAddress, String>(){

                    @Override
                    public String transformChecked(InterfaceAddress input) {
                        return "<b>" + input.getAddress().getHostAddress() + "</b>" + "/" + input.getNetworkPrefixLength();
                    }
                }));
                sb.append(" ; <i>" + TM.tr("interfaceState", new Object[0]) + " :</i> " + TM.tr(ni.isUp() ? "interfaceStateUp" : "interfaceStateDown", new Object[0]));
                sb.append(lineBreak);
                sb.append(" <i>" + TM.tr("interfaceFullName", new Object[0]) + " :</i> " + ni.getDisplayName());
                sb.append(lineBreak);
                sb.append(" <i>" + TM.tr("hardwareAddress", new Object[0]) + " :</i> ");
                Formatter fmt = new Formatter(sb);
                byte[] mac = ni.getHardwareAddress();
                int i = 0;
                while (i < mac.length) {
                    fmt.format("%02X%s", mac[i], i < mac.length - 1 ? ":" : "");
                    ++i;
                }
                ifs.add(sb.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ifs.add(e.getLocalizedMessage());
        }
        res.put(Info.NETWORK, CollectionUtils.join(ifs, lineBreak));
        return res;
    }

    public static final String getLineBreak(boolean html) {
        return html ? "<br>" : "\n";
    }

    public static final String getLink(String name, URI uri, boolean html) {
        if (uri == null) {
            return name;
        }
        if (html) {
            return "<a href=\"" + uri.toString() + "\" >" + name + "</a>";
        }
        return "[" + name + "](" + uri.toString() + ")";
    }

    private static String formatBytes(long b) {
        return TM.tr("megabytes", b / 1024L / 1024L);
    }

    public static enum Info {
        JAVA,
        OS,
        USER,
        NETWORK;

    }
}

