/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.Arrays;

public class ArrayListOfInt {
    private transient int[] elementData;
    private int size;

    public ArrayListOfInt(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new int[initialCapacity];
    }

    public ArrayListOfInt() {
        this(10);
    }

    public void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.size < oldCapacity) {
            this.elementData = Arrays.copyOf(this.elementData, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = Arrays.copyOf(this.elementData, newCapacity);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    public int indexOf(Object o) {
        int i = 0;
        while (i < this.size) {
            if (o.equals(this.elementData[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        int i = this.size - 1;
        while (i >= 0) {
            if (o.equals(this.elementData[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public Object clone() {
        ArrayListOfInt v = new ArrayListOfInt();
        v.elementData = Arrays.copyOf(this.elementData, this.size);
        return v;
    }

    public int[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    public int get(int index) {
        this.RangeCheck(index);
        return this.elementData[index];
    }

    public int set(int index, int element) {
        this.RangeCheck(index);
        int oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    public boolean add(int e) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = e;
        return true;
    }

    public void add(int index, int element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = element;
        ++this.size;
    }

    public int removeAtIndex(int index) {
        this.RangeCheck(index);
        int oldValue = this.elementData[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = 0;
        return oldValue;
    }

    public boolean remove(int o) {
        int index = 0;
        while (index < this.size) {
            if (o == this.elementData[index]) {
                this.fastRemove(index);
                return true;
            }
            ++index;
        }
        return false;
    }

    private void fastRemove(int index) {
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = 0;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean addAll(int[] a) {
        int numNew = a.length;
        this.ensureCapacity(this.size + numNew);
        System.arraycopy(a, 0, this.elementData, this.size, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    public boolean addAll(int index, int[] a) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int numNew = a.length;
        this.ensureCapacity(this.size + numNew);
        int numMoved = this.size - index;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index, this.elementData, index + numNew, numMoved);
        }
        System.arraycopy(a, 0, this.elementData, index, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        int numMoved = this.size - toIndex;
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
    }

    private void RangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }
}

