/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.openconcerto.ui.Log;
import org.openconcerto.ui.TM;
import org.openconcerto.utils.FileUtils;

public abstract class AbstractProps {
    private final Properties props = new Properties();
    private final PropertyChangeSupport propSupp = new PropertyChangeSupport(this);

    protected AbstractProps() {
        this.load();
    }

    public final void addListener(PropertyChangeListener l) {
        this.propSupp.addPropertyChangeListener(l);
    }

    public final void addListener(String name, PropertyChangeListener l) {
        this.propSupp.addPropertyChangeListener(name, l);
    }

    public final void removeListener(PropertyChangeListener l) {
        this.propSupp.removePropertyChangeListener(l);
    }

    public final void removeListener(String name, PropertyChangeListener l) {
        this.propSupp.removePropertyChangeListener(name, l);
    }

    protected abstract String getPropsFileName();

    public final boolean contains(String name) {
        return this.props.containsKey(String.valueOf(name) + this.getPropertySuffix());
    }

    public String getPropertySuffix() {
        return "";
    }

    public String getStringProperty(String name) {
        String property = this.getProperty(name);
        if (property == null) {
            return this.getDefaultStringValue();
        }
        return property;
    }

    public final String getProperty(String name) {
        String key = String.valueOf(name) + this.getPropertySuffix();
        String property = this.props.getProperty(key);
        return property;
    }

    public final Boolean getBooleanValue(String name) {
        String property = this.getProperty(name);
        if (property == null) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(property);
    }

    public final boolean getBooleanValue(String name, boolean defaultValue) {
        String property = this.getProperty(name);
        if (property == null) {
            return defaultValue;
        }
        return Boolean.valueOf(property);
    }

    public String getDefaultStringValue() {
        return "";
    }

    public final int getIntProperty(String name) {
        return this.getIntProperty(name, this.getDefautIntValue());
    }

    public final int getIntProperty(String name, int defaultVal) {
        String property = this.getProperty(name);
        return property == null ? defaultVal : Integer.valueOf(property);
    }

    protected int getDefautIntValue() {
        return -1;
    }

    public void setProperty(String key, String value) {
        String fullKey = String.valueOf(key) + this.getPropertySuffix();
        if (value == null) {
            this.props.remove(fullKey);
        } else {
            this.props.setProperty(fullKey, value);
        }
        this.propSupp.firePropertyChange(fullKey, null, value);
    }

    public void load() {
        block13: {
            File file = new File(this.getPropsFileName());
            Log.get().config("Loading properties from " + file.getAbsolutePath() + " for " + this);
            if (!file.exists()) {
                Log.get().info(String.valueOf(file.getAbsolutePath()) + " does not exist for " + this);
                return;
            }
            BufferedInputStream bufferedInputStream = null;
            try {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    bufferedInputStream = new BufferedInputStream(fileInputStream);
                    this.props.load(bufferedInputStream);
                    this.propSupp.firePropertyChange(null, null, null);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, TM.tr("abstractProps.cannotRead", file.getAbsolutePath()));
                    e.printStackTrace();
                    if (bufferedInputStream == null) break block13;
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void store() {
        block12: {
            FilterOutputStream bufferedOutputStream = null;
            File file = new File(this.getPropsFileName());
            try {
                try {
                    FileUtils.mkdir_p(file.getParentFile());
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    this.props.store(bufferedOutputStream, "");
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, TM.tr("abstractProps.cannotWrite", file.getAbsolutePath()));
                    e.printStackTrace();
                    if (bufferedOutputStream == null) break block12;
                    try {
                        bufferedOutputStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (bufferedOutputStream != null) {
                    try {
                        bufferedOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

