/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.JSONToLightUIConvertor;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUserControl;
import org.openconcerto.utils.io.JSONConverter;

public class LightUIHourEditor
extends LightUserControl {
    private int hour;
    private int minute;

    public LightUIHourEditor(JSONObject json) {
        super(json);
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.hour = ((Number)json.get("hour")).intValue();
        this.minute = ((Number)json.get("minute")).intValue();
    }

    @Override
    public JSONObject toJSON() {
        JSONObject o = super.toJSON();
        o.put("hour", this.hour);
        o.put("minute", this.minute);
        return o;
    }

    public LightUIHourEditor(String id, int hour, int minute) {
        super(id);
        this.hour = hour;
        this.minute = minute;
        this.setType(33);
        this.setValueType(1);
        this.setValue(String.valueOf(this.getIntVal()));
    }

    public LightUIHourEditor(LightUIHourEditor lightUIHourEditor) {
        super(lightUIHourEditor);
        this.hour = lightUIHourEditor.hour;
        this.minute = lightUIHourEditor.minute;
        this.setValue(String.valueOf(this.getIntVal()));
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    @Override
    public JSONToLightUIConvertor getConvertor() {
        return new JSONToLightUIConvertor(){

            @Override
            public LightUIElement convert(JSONObject json) {
                return new LightUIHourEditor(json);
            }
        };
    }

    @Override
    public Object getValueForContext() {
        return this.getIntVal();
    }

    public int getIntVal() {
        return this.hour * 60 + this.minute;
    }

    @Override
    public void _setValueFromContext(Object value) {
        Integer strValue = JSONConverter.getObjectFromJSON(value, Integer.class);
        this.hour = strValue / 60;
        this.minute = strValue % 60;
        this.setValue(String.valueOf(strValue));
    }
}

