/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.awt.Color;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.JSONToLightUIConvertor;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUserControl;

public class LightUIColorPicker
extends LightUserControl {
    public LightUIColorPicker(String id) {
        super(id);
        this.setType(32);
        this.setBorderColor(Color.BLACK);
    }

    public LightUIColorPicker(JSONObject json) {
        super(json);
    }

    public LightUIColorPicker(LightUIColorPicker element) {
        super(element);
    }

    public void setSelectedColor(Color color) {
        this.setValue(String.valueOf(color.getRGB()));
    }

    public Color getSelectedColor() {
        if (this.getValue() == null || this.getValue().isEmpty()) {
            return null;
        }
        return Color.decode(this.getValue());
    }

    @Override
    protected void _setValueFromContext(Object value) {
        this.setValue((String)value);
    }

    @Override
    public Object getValueForContext() {
        return this.getValue();
    }

    @Override
    public JSONToLightUIConvertor getConvertor() {
        return new JSONToLightUIConvertor(){

            @Override
            public LightUIElement convert(JSONObject json) {
                return new LightUIColorPicker(json);
            }
        };
    }
}

