/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.group;

import org.openconcerto.ui.group.LayoutHints;

public final class LayoutHintsBuilder {
    private boolean largeWidth;
    private boolean largeHeight;
    private boolean showLabel;
    private boolean separated;
    private boolean fillWidth;
    private boolean fillHeight;
    private boolean split;
    private boolean visible;

    public LayoutHintsBuilder(boolean largeWidth, boolean largeHeight, boolean showLabel) {
        this.largeWidth = largeWidth;
        this.largeHeight = largeHeight;
        this.showLabel = showLabel;
    }

    public LayoutHintsBuilder setLargeWidth(boolean largeWidth) {
        this.largeWidth = largeWidth;
        return this;
    }

    public LayoutHintsBuilder setLargeHeight(boolean largeHeight) {
        this.largeHeight = largeHeight;
        return this;
    }

    public LayoutHintsBuilder setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
        return this;
    }

    public LayoutHintsBuilder setSeparated(boolean separated) {
        this.separated = separated;
        return this;
    }

    public LayoutHintsBuilder setFillWidth(boolean fillWidth) {
        this.fillWidth = fillWidth;
        return this;
    }

    public LayoutHintsBuilder setFillHeight(boolean fillHeight) {
        this.fillHeight = fillHeight;
        return this;
    }

    public LayoutHintsBuilder setSplit(boolean split) {
        this.split = split;
        return this;
    }

    public LayoutHintsBuilder setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public final LayoutHints build() {
        return new LayoutHints(this.largeWidth, this.largeHeight, this.showLabel, this.separated, this.fillWidth, this.fillHeight, this.split, this.visible);
    }
}

