/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openconcerto.ui.group.Item;
import org.openconcerto.ui.group.LayoutHints;
import org.openconcerto.utils.Tuple2;

public class Group
extends Item {
    private static final Comparator<Tuple2<Item, Integer>> COMPARATOR = new Comparator<Tuple2<Item, Integer>>(){

        @Override
        public int compare(Tuple2<Item, Integer> o1, Tuple2<Item, Integer> o2) {
            int c = o1.get1().compareTo(o2.get1());
            if (c == 0) {
                c = o1.get0().getId().compareTo(o2.get0().getId());
            }
            return c;
        }
    };
    private int order;
    private final List<Tuple2<Item, Integer>> list;

    public static Group copy(Group g, Group newParent) {
        return new Group(g, newParent);
    }

    public Group(String id) {
        this(id, LayoutHints.DEFAULT_GROUP_HINTS);
    }

    public Group(String id, LayoutHints hint) {
        super(id, hint);
        this.order = 100;
        this.list = new ArrayList<Tuple2<Item, Integer>>();
    }

    public Group(Group g, Group newParent) {
        super(g, newParent);
        this.order = g.order;
        this.list = new ArrayList<Tuple2<Item, Integer>>(g.list.size());
        for (Tuple2<Item, Integer> t : g.list) {
            Item copy = Item.copy(t.get0(), this);
            this.list.add(new Tuple2<Item, Integer>(copy, t.get1()));
        }
    }

    @Override
    public synchronized void freeze() {
        super.freeze();
        for (Tuple2<Item, Integer> child : this.list) {
            child.get0().freeze();
        }
    }

    public Item addItem(String string) {
        Item res = new Item(string);
        this.add(res);
        return res;
    }

    public Item addItem(String string, LayoutHints hint) {
        Item res = new Item(string, hint);
        this.add(res);
        return res;
    }

    public void add(Item item) {
        this.add(item, this.order);
    }

    public void add(Item item, int order) {
        this.checkFrozen("add");
        item.setParent(this);
        this.list.add(new Tuple2<Item, Integer>(item, order));
        Collections.sort(this.list, COMPARATOR);
        if (this.order <= order) {
            this.order = order / 100 * 100 + 100;
        }
    }

    public final int getSize() {
        return this.list.size();
    }

    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Item getItem(int index) {
        return this.list.get(index).get0();
    }

    public Integer getOrder(int index) {
        return this.list.get(index).get1();
    }

    public boolean contains(String id) {
        return this.getDescFromID(id) != null;
    }

    public final Collection<Group> getDescendantGroups() {
        ArrayList<Group> res = new ArrayList<Group>();
        this.getDescendantGroups(res);
        return res;
    }

    protected void getDescendantGroups(Collection<Group> res) {
        for (Tuple2<Item, Integer> t : this.list) {
            if (!(t.get0() instanceof Group)) continue;
            Group g = (Group)t.get0();
            res.add(g);
            g.getDescendantGroups(res);
        }
    }

    @Override
    public final Collection<Item> getDescendantItems() {
        ArrayList<Item> res = new ArrayList<Item>();
        this.getDescendantItems(res);
        return res;
    }

    @Override
    protected void getDescendantItems(Collection<Item> res) {
        for (Tuple2<Item, Integer> t : this.list) {
            t.get0().getDescendantItems(res);
        }
    }

    @Override
    public Item getDescFromID(String id, int maxLevel) {
        Item res = super.getDescFromID(id, maxLevel);
        if (res != null || maxLevel == 0) {
            return res;
        }
        int size = this.getSize();
        int nextLevel = maxLevel < 0 ? maxLevel : maxLevel - 1;
        int i = 0;
        while (i < size) {
            Item desc = this.getItem(i).getDescFromID(id, nextLevel);
            if (desc != null) {
                return desc;
            }
            ++i;
        }
        return null;
    }

    public final Group followPath(List<String> path, boolean create) {
        int size = path.size();
        Group g = this;
        int i = 0;
        while (i < size) {
            String id = path.get(i);
            Item child = g.getChildFromID(id);
            if (child instanceof Group) {
                g = (Group)child;
            } else {
                if (child != null) {
                    throw new IllegalStateException("ID exists but isn't a group : " + child);
                }
                if (create) {
                    Group ng = new Group(id);
                    g.add(ng);
                    g = ng;
                } else {
                    return null;
                }
            }
            ++i;
        }
        return g;
    }

    public void remove(String itemId) {
        this.remove(this, itemId);
    }

    private void remove(Group group, String id) {
        this.checkFrozen("remove");
        int size = group.getSize();
        int i = 0;
        while (i < size) {
            Item b = group.getItem(i);
            if (b.getId().equals(id)) {
                this.list.remove(i);
                return;
            }
            if (b instanceof Group) {
                this.remove((Group)b, id);
            }
            ++i;
        }
    }

    public Integer getOrder(String id) {
        int size = this.getSize();
        int i = 0;
        while (i < size) {
            Tuple2<Item, Integer> b = this.list.get(i);
            if (b.get0().getId().equals(id)) {
                return b.get1();
            }
            ++i;
        }
        return null;
    }

    public int getIndex(String id) {
        int size = this.getSize();
        int i = 0;
        while (i < size) {
            Tuple2<Item, Integer> b = this.list.get(i);
            if (b.get0().getId().equals(id)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String printTree() {
        StringBuilder b = new StringBuilder();
        this.printTree(b, 0, 1);
        return b.toString();
    }

    @Override
    protected void printTree(StringBuilder builder, int localOrder, int level) {
        int i = 0;
        while (i < level - 1) {
            builder.append("  ");
            ++i;
        }
        builder.append("+-+ ");
        builder.append(String.valueOf(localOrder) + " " + this.getId() + " [" + this.getLocalHint() + "]\n");
        for (Tuple2<Item, Integer> tuple : this.list) {
            tuple.get0().printTree(builder, tuple.get1(), level + 1);
        }
    }

    public String printTwoColumns() {
        StringBuilder b = new StringBuilder("==== Group " + this.getId() + " ====\n");
        this.printColumns(b, 2, 0, 0, 1);
        return b.toString();
    }

    @Override
    protected int printColumns(StringBuilder builder, int width, int x, int localOrder, int level) {
        if (this.getLocalHint().isSeparated()) {
            x = 0;
            builder.append(" -------\n");
        }
        if (this.isEmpty()) {
            x = super.printColumns(builder, width, x, localOrder, level);
        } else {
            for (Tuple2<Item, Integer> tuple : this.list) {
                Item subGroup = tuple.get0();
                Integer subGroupOrder = tuple.get1();
                x = subGroup.printColumns(builder, width, x, subGroupOrder, level + 1);
            }
        }
        return x;
    }

    @Override
    public boolean equalsDesc(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equalsDesc(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)obj;
        int size = this.list.size();
        if (size != other.list.size()) {
            return false;
        }
        int i = 0;
        while (i < size) {
            Tuple2<Item, Integer> thisChild = this.list.get(i);
            Tuple2<Item, Integer> oChild = other.list.get(i);
            if (!thisChild.get1().equals(oChild.get1()) || !thisChild.get0().equalsDesc(oChild.get0())) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

