/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.regex.Pattern;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import net.jcip.annotations.GuardedBy;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.ITextComboCache;
import org.openconcerto.ui.component.ImmutableITextComboCache;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.ui.component.MutableListCombo;
import org.openconcerto.ui.component.MutableListComboPopupListener;
import org.openconcerto.ui.component.combo.ISearchableComboPopup;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.valuewrapper.ValueChangeSupport;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.IFutureTask;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.model.ListComboBoxModel;
import org.openconcerto.utils.text.DocumentFilterList;
import org.openconcerto.utils.text.SimpleDocumentFilter;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class ITextCombo
extends JComboBox
implements ValueWrapper<String>,
TextComponent,
InteractionMode.InteractionComponent {
    public static final String SIMPLE_TRAVERSAL = "org.openconcerto.ui.simpleTraversal";
    private static final Pattern DIGIT_PATTERN = Pattern.compile("\\d+");
    private static final String DEFAULTVALUE = "";
    private final String defaultValue;
    private final ComboLockedMode locked;
    private final ValueChangeSupport<String> supp;
    private KeyListener keyListener = null;
    private DocumentFilter docFilter = null;
    protected final boolean autoComplete;
    protected boolean keyPressed;
    private boolean completing;
    @GuardedBy(value="EDT")
    private boolean cacheLoading;
    private String objToSelect;
    @GuardedBy(value="EDT")
    private InteractionMode modeToSet;
    private InteractionMode interactionBridge;
    protected boolean modifyingDoc;
    private ITextComboCache cache;

    public ITextCombo() {
        this(DEFAULTVALUE);
    }

    public ITextCombo(String defaultValue) {
        this(defaultValue, ComboLockedMode.UNLOCKED);
    }

    public ITextCombo(boolean locked) {
        this(locked ? ComboLockedMode.LOCKED : ComboLockedMode.UNLOCKED);
    }

    public ITextCombo(ComboLockedMode mode) {
        this(DEFAULTVALUE, mode);
    }

    public ITextCombo(String defaultValue, ComboLockedMode mode) {
        super(new ListComboBoxModel());
        this.getListModel().setSelectOnAdd(false);
        this.supp = new ValueChangeSupport<String>(this);
        this.locked = mode;
        this.defaultValue = defaultValue;
        this.autoComplete = true;
        this.keyPressed = false;
        this.completing = false;
        this.cache = null;
        this.cacheLoading = false;
        this.modifyingDoc = false;
        this.setMinimumSize(new Dimension(80, 22));
        this.setPreferredSize(new Dimension(120, 22));
        this.setInteractionMode(InteractionMode.READ_WRITE);
        if (this.isLocked()) {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ITextCombo.this.supp.fireValueChange();
                }
            });
        } else {
            final SimpleDocumentListener docListener = new SimpleDocumentListener(){

                @Override
                public void update(DocumentEvent e) {
                    if (!ITextCombo.this.modifyingDoc) {
                        ITextCombo.this.setValue(SimpleDocumentListener.getText(e.getDocument()));
                    }
                    ITextCombo.this.supp.fireValueChange();
                }
            };
            this.addPropertyChangeListener("editor", new PropertyChangeListener(){
                {
                    this.changeListener(ITextCombo.this.getTextComp(), true);
                    if (!($assertionsDisabled || ITextCombo.this.keyListener == null && ITextCombo.this.docFilter == null)) {
                        throw new AssertionError();
                    }
                }

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    JTextComponent newTextComp;
                    JTextComponent oldTextComp = ITextCombo.this.getTextComp((ComboBoxEditor)evt.getOldValue());
                    if (oldTextComp != null) {
                        this.changeListener(oldTextComp, false);
                        oldTextComp.removeKeyListener(ITextCombo.this.keyListener);
                        DocumentFilterList.remove((AbstractDocument)oldTextComp.getDocument(), ITextCombo.this.docFilter);
                    }
                    if ((newTextComp = ITextCombo.this.getTextComp((ComboBoxEditor)evt.getNewValue())) != null) {
                        this.changeListener(newTextComp, true);
                        ITextCombo.this.addCompletionListeners(newTextComp);
                    }
                }

                private final void changeListener(JTextComponent textComp, boolean add) {
                    if (add) {
                        textComp.getDocument().addDocumentListener(docListener);
                    } else {
                        textComp.getDocument().removeDocumentListener(docListener);
                    }
                }
            });
        }
        this.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component res = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (!isSelected && value != null && value.equals(ITextCombo.this.getValue())) {
                    ISearchableComboPopup.setCurrentValueBG(list, res);
                }
                return res;
            }
        });
        if (Boolean.getBoolean(SIMPLE_TRAVERSAL)) {
            Component[] componentArray = this.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component child = componentArray[n2];
                if (child instanceof JButton || child instanceof Button) {
                    child.setFocusable(false);
                }
                ++n2;
            }
        }
        this.resetValue();
    }

    @Override
    public void configureEditor(ComboBoxEditor anEditor, Object anItem) {
        if (!anEditor.getItem().equals(anItem)) {
            super.configureEditor(anEditor, anItem);
        }
    }

    protected final ComboLockedMode getMode() {
        return this.locked;
    }

    private boolean isLocked() {
        return this.locked == ComboLockedMode.LOCKED;
    }

    public final boolean hasCache() {
        return this.cache != null;
    }

    public final Future<? extends ITextCombo> initCache(String ... values) {
        return this.initCache(Arrays.asList(values));
    }

    public final Future<? extends ITextCombo> initCache(List<String> values) {
        return this.initCache(new ImmutableITextComboCache(values));
    }

    public final Future<? extends ITextCombo> initCache(ITextComboCache cache) {
        if (cache == null) {
            throw new NullPointerException("null cache");
        }
        if (this.hasCache()) {
            throw new IllegalStateException("cache already set " + this.cache);
        }
        this.cache = cache;
        assert (this.hasCache());
        new MutableListComboPopupListener(new MutableListCombo(){

            @Override
            public ComboLockedMode getMode() {
                return ITextCombo.this.getMode();
            }

            @Override
            public Component getPopupComp() {
                return ITextCombo.this.getEditor().getEditorComponent();
            }

            @Override
            public boolean canModifyCache() {
                return true;
            }

            @Override
            public void addCurrentText() {
                ITextCombo.this.addCurrentText();
            }

            @Override
            public void removeCurrentText() {
                ITextCombo.this.removeCurrentText();
            }

            @Override
            public boolean canReload() {
                return true;
            }

            @Override
            public void reload() {
                ITextCombo.this.loadCache(true);
            }
        }).listen();
        Future<? extends ITextCombo> future = this.loadCache(false);
        if (!this.isLocked()) {
            this.keyListener = new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    ITextCombo.this.keyPressed = true;
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    ITextCombo.this.keyPressed = false;
                }
            };
            this.docFilter = new SimpleDocumentFilter(){

                @Override
                protected boolean change(DocumentFilter.FilterBypass fb, String newText, SimpleDocumentFilter.Mode mode) throws BadLocationException {
                    if (mode != SimpleDocumentFilter.Mode.REMOVE && ITextCombo.this.autoComplete && ITextCombo.this.keyPressed) {
                        return ITextCombo.this.complete(fb, newText);
                    }
                    return true;
                }
            };
            this.addCompletionListeners(this.getTextComp());
        }
        return future;
    }

    protected final void addCompletionListeners(JTextComponent textComp) {
        textComp.addKeyListener(this.keyListener);
        DocumentFilterList.add((AbstractDocument)textComp.getDocument(), this.docFilter);
    }

    protected final boolean complete(DocumentFilter.FilterBypass fb, String originalText) throws BadLocationException {
        boolean res = true;
        if (!this.completing) {
            String completion;
            this.completing = true;
            if (this.canComplete(originalText) && (completion = this.getCompletion(originalText)) != null && !originalText.trim().equalsIgnoreCase(completion.trim())) {
                fb.replace(0, fb.getDocument().getLength(), completion, null);
                res = false;
                this.getTextComp().setSelectionStart(originalText.length());
                this.getTextComp().setSelectionEnd(completion.length());
            }
            this.completing = false;
        }
        return res;
    }

    public boolean canComplete(String originalText) {
        return originalText.length() > 2 && !DIGIT_PATTERN.matcher(originalText).matches();
    }

    private String getCompletion(String string) {
        if (string.length() < 1) {
            return null;
        }
        int count = 0;
        String result = null;
        for (Object obj : this.getListModel().getList()) {
            String item = (String)obj;
            if (!item.startsWith(string)) continue;
            ++count;
            result = item;
        }
        if (count == 1) {
            return result;
        }
        return null;
    }

    private ListComboBoxModel getListModel() {
        return (ListComboBoxModel)this.getModel();
    }

    @Override
    public InteractionMode getInteractionMode() {
        return this.interactionBridge;
    }

    @Override
    public void setInteractionMode(InteractionMode mode) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.cacheLoading) {
            this.modeToSet = mode;
        } else if (mode != this.interactionBridge) {
            this.interactionBridge = mode;
            super.setEnabled(mode.isEditable());
            boolean superEditable = !this.isLocked() || mode == InteractionMode.READ_ONLY;
            super.setEditable(superEditable);
            if (superEditable) {
                JTextComponent comp = this.getTextComp(this.getEditor());
                mode.applyTo(comp);
            } else assert (this.getTextComp(this.getEditor()) == null || !this.getTextComp(this.getEditor()).isDisplayable());
        }
    }

    @Override
    public void setEditable(boolean b) {
        super.setEditable(b);
    }

    @Override
    public void setEnabled(boolean b) {
        this.setInteractionMode(b ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
    }

    public final synchronized Future<? extends ITextCombo> loadCache(final boolean force) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.cacheLoading) {
            this.modeToSet = this.getInteractionMode();
            this.setEnabled(false);
            this.objToSelect = this.getValue();
            this.cacheLoading = true;
            final FutureTask<ITextCombo> noop = IFutureTask.createNoOp(this);
            SwingWorker<List<String>, Object> sw = new SwingWorker<List<String>, Object>(){

                @Override
                protected List<String> doInBackground() throws Exception {
                    return force ? ITextCombo.this.cache.loadCache(false) : ITextCombo.this.cache.getCache();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    8 var1_1 = this;
                    synchronized (var1_1) {
                        ITextCombo.this.modifyingDoc = true;
                    }
                    ITextCombo.this.getListModel().removeAllElements();
                    try {
                        ITextCombo.this.getListModel().addAll((Collection)this.get());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ITextCombo.this.getListModel().addElement(e.getLocalizedMessage());
                    }
                    var1_1 = this;
                    synchronized (var1_1) {
                        ITextCombo.this.modifyingDoc = false;
                        ITextCombo.this.cacheLoading = false;
                    }
                    if (ITextCombo.this.isLocked() && ITextCombo.this.getModel().getSize() == 0) {
                        throw new IllegalStateException(ITextCombo.this + " locked but no items.");
                    }
                    ITextCombo.this.setInteractionMode(ITextCombo.this.modeToSet);
                    ITextCombo.this.setValue(ITextCombo.this.objToSelect);
                    noop.run();
                }
            };
            sw.execute();
            return noop;
        }
        return null;
    }

    private final Object makeObj(String item) {
        return item;
    }

    private final boolean addToCache(String s) {
        boolean added;
        boolean bl = added = s != null && s.length() > 0 && this.getListModel().getList().indexOf(s) < 0;
        if (added) {
            Object obj = this.makeObj(s);
            this.completing = true;
            this.setSelectedItem(obj);
            this.completing = false;
            this.addItem(obj);
        }
        return added;
    }

    private final void removeCurrentText() {
        String t = this.getTextComp().getText();
        this.cache.deleteFromCache(t);
        int i = 0;
        while (i < this.getItemCount()) {
            String o = (String)this.getItemAt(i);
            if (o.equals(t)) {
                this.removeItemAt(i);
                break;
            }
            ++i;
        }
    }

    private final void addCurrentText() {
        String t = this.getTextComp().getText();
        if (this.addToCache(t)) {
            this.cache.addToCache(t);
        }
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addValueListener(l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.rmValueListener(l);
    }

    final boolean isCacheLoading() {
        return this.cacheLoading;
    }

    @Override
    public final synchronized void setValue(String val) {
        if (!CompareUtils.equals(this.getValue(), val)) {
            if (this.cacheLoading) {
                this.objToSelect = val;
                this.supp.fireValueChange();
            } else {
                this.completing = true;
                this.setSelectedItem(this.makeObj(val));
                this.completing = false;
            }
        }
    }

    @Override
    public void resetValue() {
        this.setValue(this.defaultValue);
    }

    @Override
    public String getValue() {
        if (this.cacheLoading) {
            return this.objToSelect;
        }
        return this.getCurrentValue();
    }

    public String getCurrentValue() {
        ComboBoxEditor editor;
        Object res = this.isLocked() ? this.getSelectedItem() : ((editor = this.getEditor()) == null ? null : editor.getItem());
        return (String)res;
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public ValidState getValidState() {
        return ValidState.getTrueInstance();
    }

    @Override
    public void addValidListener(ValidListener l) {
    }

    @Override
    public void removeValidListener(ValidListener l) {
    }

    private final JTextComponent getTextComp(ComboBoxEditor editor) {
        Component editorComp;
        if (editor != null && (editorComp = editor.getEditorComponent()) instanceof JTextComponent) {
            return (JTextComponent)editorComp;
        }
        return null;
    }

    @Override
    public JTextComponent getTextComp() {
        if (this.isLocked()) {
            return null;
        }
        return this.getTextComp(this.getEditor());
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + " " + (Object)((Object)this.locked) + " cache: " + this.cache;
    }
}

