/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.openconcerto.ui.EnhancedTable;
import org.openconcerto.utils.text.DocumentFilterList;
import org.openconcerto.utils.text.LimitedSizeDocumentFilter;

public class TextAreaTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    final JTextArea textArea = new JTextArea();

    public TextAreaTableCellEditor(final JTable t) {
        this.textArea.setBorder(new LineBorder(Color.black));
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    e.consume();
                    final int row = t.getEditingRow();
                    final int column = e.getModifiers() == 1 ? t.getEditingColumn() - 1 : t.getEditingColumn() + 1;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (t.getCellEditor() != null && t.getCellEditor().stopCellEditing() && column >= 0 && column < t.getColumnCount()) {
                                t.setColumnSelectionInterval(column, column);
                                t.setRowSelectionInterval(row, row);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (t.editCellAt(row, column)) {
                                            t.getEditorComponent().requestFocusInWindow();
                                        }
                                    }
                                });
                            }
                        }
                    });
                } else if (e.getKeyCode() == 32 && e.getModifiers() == 1) {
                    e.setModifiers(0);
                }
            }
        });
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.textArea.setFont(t.getFont());
        this.textArea.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                TextAreaTableCellEditor.this.updateRowHeight(t, TextAreaTableCellEditor.this.textArea.getText());
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextAreaTableCellEditor.this.updateRowHeight(t, e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextAreaTableCellEditor.this.updateRowHeight(t, e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextAreaTableCellEditor.this.updateRowHeight(t, e);
            }
        });
    }

    private void updateRowHeight(JTable t, DocumentEvent e) {
        String newText = "";
        try {
            newText = e.getDocument().getText(0, e.getDocument().getLength());
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        this.updateRowHeight(t, newText);
        t.invalidate();
        t.repaint();
    }

    public static int getHeightFor(String s, JTextArea textArea) {
        Rectangle r = null;
        try {
            r = textArea.modelToView(s.length());
        }
        catch (BadLocationException e) {
            return -1;
        }
        int h = 0;
        if (r != null) {
            int newHeight = r.y + r.height + 2;
            h = Math.max(textArea.getMinimumSize().height, newHeight);
        }
        return h;
    }

    public void updateRowHeight(JTable t, String newText) {
        int preferredHeight = TextAreaTableCellEditor.getHeightFor(newText, this.textArea);
        if (preferredHeight == -1) {
            preferredHeight = this.textArea.getPreferredSize().height + 17;
        }
        EnhancedTable eTable = (EnhancedTable)t;
        int editingRow = eTable.getEditingRow();
        int editingCol = eTable.getEditingColumn();
        eTable.setPreferredRowHeight(editingRow, editingCol, preferredHeight);
        int maxHeight = eTable.getMaxRowHeight(editingRow);
        if (t.getRowHeight(editingRow) != maxHeight) {
            t.setRowHeight(editingRow, maxHeight);
        }
        t.repaint();
    }

    protected JTextArea getTextArea() {
        return this.textArea;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Object o = value;
        this.textArea.setText(o != null ? o.toString() : "");
        this.textArea.selectAll();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                TextAreaTableCellEditor.this.textArea.grabFocus();
            }
        };
        SwingUtilities.invokeLater(r);
        return this.textArea;
    }

    @Override
    public Object getCellEditorValue() {
        return this.textArea.getText();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.stopCellEditing();
    }

    public void setLimitedSize(int nbChar) {
        DocumentFilterList dfl = DocumentFilterList.get((AbstractDocument)this.textArea.getDocument());
        Iterator<DocumentFilter> iter = dfl.getFilters().iterator();
        while (iter.hasNext()) {
            DocumentFilter df = iter.next();
            if (!(df instanceof LimitedSizeDocumentFilter)) continue;
            iter.remove();
        }
        DocumentFilterList.add((AbstractDocument)this.textArea.getDocument(), new LimitedSizeDocumentFilter(nbChar), DocumentFilterList.FilterType.SIMPLE_FILTER);
    }
}

