/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;

public class RangedIntegerTableCellEditor
extends DefaultCellEditor {
    private int min;
    private int max;

    public RangedIntegerTableCellEditor(int min, int max) {
        super(new JTextField());
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.getCellEditorValue();
            return super.stopCellEditing();
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public Object getCellEditorValue() {
        String str = (String)super.getCellEditorValue();
        if (str == null || str.length() == 0) {
            return this.min;
        }
        try {
            int i = Integer.parseInt(str);
            if (i < this.min) {
                i = this.min;
            } else if (i > this.max) {
                i = this.max;
            }
            return i;
        }
        catch (Exception ex) {
            throw new IllegalStateException();
        }
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setMin(int min) {
        this.min = min;
    }
}

