/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.openconcerto.ui.TimeTextField;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.checks.ValidChangeSupport;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;

public final class JValidTime
extends JPanel
implements ValueWrapper<Date>,
TextComponent {
    private final boolean fillWithCurrentTime;
    private final TimeTextField text;
    private final ValidChangeSupport validSupp;

    public JValidTime() {
        this(false);
    }

    public JValidTime(boolean fillWithCurrentTime) {
        super(new BorderLayout());
        this.fillWithCurrentTime = fillWithCurrentTime;
        this.text = new TimeTextField();
        this.add((Component)this.text, "Center");
        this.text.addPropertyChangeListener("editValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JValidTime.this.setValidated((Boolean)evt.getNewValue());
            }
        });
        this.validSupp = new ValidChangeSupport(this, ValidState.getNoReasonInstance(true));
        this.resetValue();
    }

    private JTextComponent getEditor() {
        return this.text;
    }

    @Override
    public final void resetValue() {
        if (this.fillWithCurrentTime) {
            Calendar c = Calendar.getInstance();
            this.setTime(c.get(11), c.get(12));
        } else {
            this.setValue(null);
        }
    }

    @Override
    public final void setValue(Date val) {
        if (val == null) {
            this.text.setTime(0, 0);
        } else {
            long minutes = val.getTime() / 60000L;
            System.out.println(minutes);
            this.text.setTime((int)(minutes / 60L), (int)(minutes % 60L));
        }
    }

    @Override
    public final Date getValue() {
        return new Date(this.getTimeInMillis());
    }

    public void setTime(int hours, int minutes) {
        this.text.setTime(hours, minutes);
    }

    public int getHours() {
        return this.text.getHours();
    }

    public int getMinutes() {
        return this.text.getMinutes();
    }

    @Override
    public final void addValueListener(PropertyChangeListener l) {
        this.getEditor().addPropertyChangeListener("value", l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.getEditor().removePropertyChangeListener("value", l);
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    protected final void setValidated(boolean newValue) {
        this.validSupp.fireValidChange(ValidState.getNoReasonInstance(newValue));
    }

    @Override
    public ValidState getValidState() {
        return this.validSupp.getValidState();
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.validSupp.addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.validSupp.removeValidListener(l);
    }

    @Override
    public JTextComponent getTextComp() {
        return this.getEditor();
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        JValidTime t = new JValidTime(true);
        t.setTimeInMillis(7800000L);
        System.out.println(t.getTimeInMillis());
        f.setContentPane(t);
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    public long getTimeInMillis() {
        return (this.getHours() * 60 + this.getMinutes()) * 60 * 1000;
    }

    public void setTimeInMillis(long ms) {
        this.setValue(new Date(ms));
    }
}

