/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.text.DateFormatter;
import javax.swing.text.JTextComponent;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.TimeUtils;
import org.openconcerto.utils.checks.ValidChangeSupport;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;

public final class JTime
extends JPanel
implements ValueWrapper<Date>,
TextComponent {
    private static final Calendar CAL = Calendar.getInstance();
    private static final long DAY_LENGTH = 86400000L;
    private final boolean fillWithCurrentHour;
    private final JFormattedTextField text;
    private final ValidChangeSupport validSupp;

    private static final Date dateFromTimeInMillis(Long val) {
        if (val == null) {
            return null;
        }
        return JTime.dateFromTimeInMillis(val.intValue());
    }

    private static final Date dateFromTimeInMillis(int val) {
        if ((long)val >= 86400000L) {
            throw new IllegalArgumentException("Val is greater than a day : " + val);
        }
        CAL.clear();
        CAL.add(14, val);
        return CAL.getTime();
    }

    public JTime() {
        this(false);
    }

    public JTime(boolean fillWithCurrentHour) {
        this(fillWithCurrentHour, false);
    }

    public JTime(boolean fillWithCurrentHour, boolean withSeconds) {
        super(new BorderLayout());
        this.fillWithCurrentHour = fillWithCurrentHour;
        DateFormatter formatter = new DateFormatter(new SimpleDateFormat(withSeconds ? "HH:mm:ss" : "HH:mm"));
        formatter.setOverwriteMode(true);
        formatter.setMaximum(JTime.dateFromTimeInMillis(86399999L));
        this.text = new JFormattedTextField(formatter);
        int h = this.text.getPreferredSize().height;
        this.text.setMinimumSize(new Dimension(40, h));
        this.text.setPreferredSize(new Dimension(50, h));
        this.add((Component)this.text, "Center");
        this.text.addPropertyChangeListener("editValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JTime.this.setValidated((Boolean)evt.getNewValue());
            }
        });
        this.validSupp = new ValidChangeSupport(this, ValidState.getNoReasonInstance(this.text.isEditValid()));
        this.resetValue();
    }

    private JTextComponent getEditor() {
        return this.text;
    }

    @Override
    public final void resetValue() {
        if (this.fillWithCurrentHour) {
            this.setTimeInMillis((long)Calendar.getInstance().get(11) * 3600L * 1000L);
        } else {
            this.setValue(null);
        }
    }

    @Override
    public final void setValue(Date val) {
        Long time;
        if (val == null) {
            time = null;
        } else {
            CAL.setTime(val);
            TimeUtils.clearTime(CAL);
            long woTime = CAL.getTimeInMillis();
            time = val.getTime() - woTime;
        }
        this.setTimeInMillis(time);
    }

    public final void setTimeInMillis(Long val) {
        this.text.setValue(JTime.dateFromTimeInMillis(val));
    }

    @Override
    public final Date getValue() {
        return (Date)this.text.getValue();
    }

    public final Long getTimeInMillis() {
        Date txtVal = this.getValue();
        if (txtVal == null) {
            return null;
        }
        return txtVal.getTime() + (long)CAL.getTimeZone().getOffset(txtVal.getTime());
    }

    @Override
    public final void addValueListener(PropertyChangeListener l) {
        this.getEditor().addPropertyChangeListener("value", l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.getEditor().removePropertyChangeListener("value", l);
    }

    public void commitEdit() throws ParseException {
        this.text.commitEdit();
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    protected final void setValidated(boolean newValue) {
        this.validSupp.fireValidChange(ValidState.getNoReasonInstance(newValue));
    }

    @Override
    public ValidState getValidState() {
        return this.validSupp.getValidState();
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.validSupp.addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.validSupp.removeValidListener(l);
    }

    @Override
    public JTextComponent getTextComp() {
        return this.getEditor();
    }
}

