/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openconcerto.sql.view.list.VirtualMenuGroup;

public class VirtualMenu
extends VirtualMenuGroup.Item {
    public static final int MIN_SIZE = 2;
    public static final int MAX_SIZE = 50;
    protected static final VirtualMenu EMPTY = new VirtualMenu(null, null, null, 1, 1, Collections.emptyMap());
    private final String name;
    private final String defaultGroup;
    private int minSize;
    private int maxSize;
    private final Map<String, VirtualMenuGroup> groups;

    static VirtualMenu createRoot(String defaultGroup) {
        return new VirtualMenu(null, null, defaultGroup, 2, 50);
    }

    static VirtualMenu createFromParentMenu(VirtualMenuGroup parent, String name) {
        VirtualMenu parentMenu = parent.getParentMenu();
        return new VirtualMenu(parent, name, parentMenu.getDefaultGroupName(), parentMenu.minSize, parentMenu.maxSize);
    }

    private VirtualMenu(VirtualMenuGroup parent, String name, String defaultGroup, int minSize, int maxSize) {
        this(parent, name, defaultGroup, minSize, maxSize, new LinkedHashMap<String, VirtualMenuGroup>());
    }

    private VirtualMenu(VirtualMenuGroup parent, String name, String defaultGroup, int minSize, int maxSize, Map<String, VirtualMenuGroup> groups) {
        super(parent);
        this.name = name;
        this.defaultGroup = defaultGroup;
        this.setMinSize(minSize);
        this.setMaxSize(maxSize);
        this.groups = groups;
    }

    public final VirtualMenu setMinSize(int minSize) {
        this.minSize = minSize;
        return this;
    }

    public final VirtualMenu setMaxSize(int maxSize) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("Max size should be at least 1");
        }
        this.maxSize = maxSize;
        return this;
    }

    final VirtualMenu getParentMenu() {
        return this.getParentGroup().getParentMenu();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    final List<String> getPath() {
        if (this.getParentGroup() == null) {
            return new ArrayList<String>();
        }
        List<String> res = this.getParentGroup().getPath();
        res.add(this.getName());
        assert (res.size() % 2 == 0);
        return res;
    }

    public final String getDefaultGroupName() {
        return this.defaultGroup;
    }

    protected final VirtualMenuGroup getGroup(String name) {
        VirtualMenuGroup res = this.groups.get(name);
        if (res == null) {
            res = new VirtualMenuGroup(this, name);
            this.groups.put(name, res);
        }
        return res;
    }

    public final VirtualMenu addAction(Action a) {
        return this.addItem(new JMenuItem(a));
    }

    public final VirtualMenu addItem(JMenuItem mi) {
        return this.addItem(mi, this.getDefaultGroupName());
    }

    public final VirtualMenu addItem(JMenuItem mi, String group) {
        this.getGroup(group).add(mi);
        return this;
    }

    public final VirtualMenu getSubmenu(String name) {
        return this.getSubmenu(name, this.getDefaultGroupName());
    }

    public final VirtualMenu getSubmenu(String name, String group) {
        return this.getGroup(group).getMenu(name);
    }

    final VirtualMenu getSubmenu(List<String> path) {
        if (path.size() % 2 != 0) {
            throw new IllegalArgumentException("Path should be group/submenu/... :" + path);
        }
        VirtualMenu res = this;
        int i = 0;
        while (i < path.size()) {
            res = res.getSubmenu(path.get(i + 1), path.get(i));
            i += 2;
        }
        return res;
    }

    final VirtualMenu addItem(JMenuItem mi, List<String> path) {
        return this.getSubmenu(path.subList(0, path.size() - 1)).addItem(mi, path.get(path.size() - 1));
    }

    final void merge(VirtualMenu m) {
        for (VirtualMenuGroup g : m.groups.values()) {
            this.getGroup(g.getName()).merge(g);
        }
        this.minSize = Math.min(this.minSize, m.minSize);
        this.maxSize = Math.max(this.maxSize, m.maxSize);
    }

    /*
     * WARNING - void declaration
     */
    final void applySizeConstraints() {
        int size = 0;
        for (VirtualMenuGroup g : this.groups.values()) {
            for (VirtualMenu virtualMenu : g.getMenus().values()) {
                virtualMenu.applySizeConstraints();
            }
            size += g.getItemCount();
        }
        if (size < this.minSize) {
            if (this.getParentGroup() != null && this.getParentMenu().hasRoomFor(size)) {
                VirtualMenuGroup group = this.getParentMenu().getGroup(this.getParentGroup().getName());
                for (VirtualMenuGroup g : this.groups.values()) {
                    group.addAll(g.getItems());
                }
                this.getParentGroup().remove(this);
            }
        } else if (size > this.maxSize) {
            void var4_8;
            ArrayList<VirtualMenuGroup.Item> items = new ArrayList<VirtualMenuGroup.Item>();
            for (VirtualMenuGroup g : this.groups.values()) {
                for (VirtualMenuGroup.Item item : g.getItems()) {
                    items.add(item);
                }
            }
            assert (size == items.size());
            VirtualMenu submenu = null;
            int n = this.maxSize;
            while (var4_8 < size) {
                VirtualMenuGroup.Item item;
                item = (VirtualMenuGroup.Item)items.get((int)var4_8);
                if (var4_8 % this.maxSize == false) {
                    submenu = this.getParentGroup() == null ? this.getSubmenu("suite " + (int)(var4_8 / this.maxSize), null) : this.getParentMenu().getSubmenu(String.valueOf(this.getName()) + " (suite " + (int)(var4_8 / this.maxSize) + ")", this.getParentGroup().getName());
                }
                submenu.getGroup(item.getParentGroup().getName()).add(item);
                ++var4_8;
            }
        }
    }

    private int getItemCount() {
        int size = 0;
        for (VirtualMenuGroup g : this.groups.values()) {
            size += g.getItemCount();
        }
        return size;
    }

    private boolean hasRoomFor(int size) {
        return this.maxSize - this.getItemCount() >= size;
    }

    Map<JMenuItem, List<String>> getItemsAndPath(boolean recurse) {
        LinkedHashMap<JMenuItem, List<String>> res = new LinkedHashMap<JMenuItem, List<String>>();
        for (VirtualMenuGroup g : this.groups.values()) {
            for (VirtualMenuGroup.Item i : g.getItems()) {
                if (i instanceof VirtualMenuGroup.LeafItem) {
                    res.put(((VirtualMenuGroup.LeafItem)i).getJMenuItem(), i.getPath());
                    continue;
                }
                if (!recurse) continue;
                res.putAll(((VirtualMenu)i).getItemsAndPath(recurse));
            }
        }
        return res;
    }

    final Map<JMenuItem, List<String>> getContent() {
        this.applySizeConstraints();
        return this.getItemsAndPath(true);
    }
}

