/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.RowValuesSelector;
import org.openconcerto.sql.view.list.RowValuesTableModel;

public class RowValuesSelectorPanel
extends JPanel {
    private final RowValuesSelector rowValuesSelector;

    public RowValuesSelectorPanel(RowValuesTableModel model, File file) {
        this(model, file, "South");
    }

    public RowValuesSelectorPanel(RowValuesTableModel model, File file, String toolbarPosition) {
        this.setLayout(new BorderLayout());
        this.rowValuesSelector = new RowValuesSelector(model, file);
        this.add((Component)new JScrollPane(this.rowValuesSelector), "Center");
        this.add((Component)this.createMenu(), toolbarPosition);
    }

    private JPanel createMenu() {
        JPanel menu = new JPanel();
        menu.setLayout(new FlowLayout(0));
        final JButton buttonSelect = new JButton("S\u00e9lectionner tout");
        buttonSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowValuesSelectorPanel.this.rowValuesSelector.selectAll();
            }
        });
        menu.add(buttonSelect);
        final JButton buttonUnselect = new JButton("D\u00e9s\u00e9lectionner tout");
        buttonUnselect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowValuesSelectorPanel.this.rowValuesSelector.unselectAll();
            }
        });
        menu.add(buttonUnselect);
        TableModelListener l = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                boolean empty = ((TableModel)e.getSource()).getRowCount() == 0;
                buttonSelect.setEnabled(!empty);
                buttonUnselect.setEnabled(!empty);
            }
        };
        buttonSelect.setEnabled(false);
        buttonUnselect.setEnabled(false);
        this.rowValuesSelector.getModel().addTableModelListener(l);
        return menu;
    }

    public synchronized List<SQLRowValues> getSelectedRowValues() {
        return this.rowValuesSelector.getSelectedRowValues();
    }

    public JTable getTable() {
        return this.rowValuesSelector;
    }
}

