/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import com.mysql.jdbc.ConnectionProperties;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.ConnectionHandler;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRequestLog;
import org.openconcerto.sql.model.SQLResultSet;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.utils.RTInterruptedException;

public class SQLUtils {
    public static final String SPLIT_DELIMITER = "$jdbcDelimiter$";
    private static final Pattern splitMySQLQueries = Pattern.compile(";\r?\n");
    public static final Pattern SPLIT_PATTERN = Pattern.compile("$jdbcDelimiter$", 16);

    public static final SQLException findWithSQLState(Exception exn) {
        Throwable e = exn;
        while (e != null) {
            SQLException sqlExn;
            if (e instanceof SQLException && (sqlExn = (SQLException)e).getSQLState() != null) {
                return sqlExn;
            }
            e = e.getCause();
        }
        return null;
    }

    public static <T> T executeAtomic(SQLDataSource ds, final SQLFactory<T> f) throws SQLException {
        return SQLUtils.executeAtomic(ds, new ConnectionHandlerNoSetup<T, SQLException>(){

            @Override
            public T handle(SQLDataSource ds) throws SQLException {
                return f.create();
            }
        });
    }

    public static <T, X extends Exception> T executeAtomic(SQLDataSource ds, ConnectionHandlerNoSetup<T, X> h) throws SQLException, X {
        return SQLUtils.executeAtomic(ds, h, false);
    }

    public static <T, X extends Exception> T executeAtomic(final SQLDataSource ds, final ConnectionHandlerNoSetup<T, X> h, final boolean continueTx) throws SQLException, X {
        return ds.useConnection(new ConnectionHandler<T, X>(){
            private Boolean autoCommit = null;
            private Savepoint savePoint = null;

            @Override
            public boolean canRestoreState() {
                return true;
            }

            @Override
            public void setup(Connection conn) throws SQLException {
                this.autoCommit = conn.getAutoCommit();
                if (this.autoCommit.booleanValue()) {
                    conn.setAutoCommit(false);
                } else if (!continueTx) {
                    this.savePoint = conn.setSavepoint();
                }
            }

            @Override
            public T handle(SQLDataSource ds2) throws Exception, SQLException {
                return h.handle(ds2);
            }

            @Override
            public void restoreState(Connection conn) throws SQLException {
                boolean hasSavePoint;
                boolean hasStoppedAutoCommit = Boolean.TRUE.equals(this.autoCommit);
                boolean bl = hasSavePoint = this.savePoint != null;
                if (!$assertionsDisabled && hasStoppedAutoCommit && hasSavePoint) {
                    throw new AssertionError((Object)"Begun a transaction and created a save point");
                }
                if (hasStoppedAutoCommit || hasSavePoint) {
                    boolean hasException = this.hasException();
                    try {
                        if (hasException) {
                            if (hasStoppedAutoCommit) {
                                conn.rollback();
                                conn.setAutoCommit(true);
                            } else {
                                conn.rollback(this.savePoint);
                            }
                        } else if (hasStoppedAutoCommit) {
                            conn.setAutoCommit(true);
                        } else if (ds.getSystem() != SQLSystem.MSSQL) {
                            conn.releaseSavepoint(this.savePoint);
                        }
                    }
                    catch (Exception e) {
                        String msg = hasException ? "Couldn't " + (hasSavePoint ? "rollback save point" : "rollback") : "Couldn't " + (hasSavePoint ? "release save point" : "commit");
                        throw new SQLException(msg, e);
                    }
                }
            }
        });
    }

    public static <T> T executeAtomic(Connection conn, SQLFactory<T> f) throws SQLException {
        T res;
        block7: {
            boolean autoCommit = conn.getAutoCommit();
            if (autoCommit) {
                conn.setAutoCommit(false);
                try {
                    try {
                        res = f.create();
                        conn.commit();
                        break block7;
                    }
                    catch (SQLException e) {
                        conn.rollback();
                        throw e;
                    }
                    catch (RuntimeException e) {
                        conn.rollback();
                        throw e;
                    }
                }
                finally {
                    conn.setAutoCommit(true);
                }
            }
            res = f.create();
        }
        return res;
    }

    public static List<String> createPostgreSQLSeq(String seqName, String sqlType, String minVal, String inc) {
        ArrayList<String> res = new ArrayList<String>();
        String genT = String.valueOf(seqName) + "_generator";
        res.add("DROP TABLE if exists " + genT);
        res.add("CREATE TABLE " + genT + " ( " + SQLUtils.decl(new String[]{"minVal", "inc", "currentVal", "tmpVal"}, sqlType) + ")");
        String body = "UPDATE " + genT + " set tmpVal = currentVal, currentVal = currentVal + inc ;";
        body = String.valueOf(body) + "SELECT tmpVal from " + genT + ";";
        res.addAll(SQLUtils.createFunction("next_" + seqName, sqlType, body));
        body = "update " + genT + " set currentVal = minVal ;";
        body = String.valueOf(body) + "select currentVal from " + genT + ";";
        res.addAll(SQLUtils.createFunction("reset_" + seqName, sqlType, body));
        res.add("INSERT INTO " + genT + " values(" + minVal + ", (" + inc + ") )");
        res.add("SELECT reset_" + seqName + "()");
        return res;
    }

    private static String decl(String[] cols, String type) {
        String res = "";
        String[] stringArray = cols;
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            String col = stringArray[n2];
            res = String.valueOf(res) + col + " " + type + ",";
            ++n2;
        }
        return res.substring(0, res.length() - 1);
    }

    private static List<String> createFunction(String name, String type, String body) {
        ArrayList<String> res = new ArrayList<String>();
        res.add("DROP FUNCTION if exists " + name + "()");
        String f = "CREATE FUNCTION " + name + "() RETURNS " + type + " AS $createFunction$ ";
        f = String.valueOf(f) + body;
        f = String.valueOf(f) + " $createFunction$ LANGUAGE SQL";
        res.add(f);
        return res;
    }

    public static void executeScript(String sql, DBSystemRoot sysRoot) throws SQLException {
        SQLSystem sys = sysRoot.getServer().getSQLSystem();
        Pattern p = sys == SQLSystem.MYSQL || sys == SQLSystem.MSSQL ? splitMySQLQueries : SPLIT_PATTERN;
        SQLUtils.executeScript(sql, sysRoot, p);
    }

    public static void executeScript(String sql, DBSystemRoot sysRoot, Pattern p) throws SQLException {
        try {
            String[] stringArray = p.split(sql);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String trimmed = s.trim();
                if (trimmed.length() > 0) {
                    sysRoot.getDataSource().execute(trimmed, (ResultSetHandler)null);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new SQLException("unable to execute " + sql, e);
        }
    }

    public static List<?> executeMultiple(final DBSystemRoot sysRoot, final List<String> queries, final List<? extends ResultSetHandler> handlers) throws SQLException, RTInterruptedException {
        final int size = handlers.size();
        if (queries.size() != size) {
            throw new IllegalArgumentException("Size mismatch " + queries + " / " + handlers);
        }
        final ArrayList results = new ArrayList(size);
        final SQLSystem system = sysRoot.getServer().getSQLSystem();
        if (system.isMultipleResultSetsSupported()) {
            long time;
            final long timeMs = System.currentTimeMillis();
            final long afterCache = time = System.nanoTime();
            StringBuilder sb = new StringBuilder(256 * size);
            for (String q : queries) {
                sb.append(q);
                if (!q.trim().endsWith(";")) {
                    sb.append(';');
                }
                sb.append('\n');
            }
            final String query = sb.toString();
            sysRoot.getDataSource().useConnection(new ConnectionHandlerNoSetup<Object, SQLException>(){

                @Override
                public Object handle(SQLDataSource ds) throws SQLException {
                    long afterHandle;
                    long afterExecute;
                    ConnectionProperties connectionProperties;
                    Connection conn = ds.getConnection();
                    if (system == SQLSystem.MYSQL && !(connectionProperties = (ConnectionProperties)((DelegatingConnection)conn).getInnermostDelegate()).getAllowMultiQueries()) {
                        throw new IllegalStateException("Multi queries not allowed and the setting can only be set before connecting");
                    }
                    long afterQueryInfo = System.nanoTime();
                    int count = 0;
                    try (Statement stmt = conn.createStatement();){
                        if (Thread.currentThread().isInterrupted()) {
                            throw new RTInterruptedException("Interrupted before executing : " + query);
                        }
                        stmt.execute(query);
                        afterExecute = System.nanoTime();
                        for (ResultSetHandler h : handlers) {
                            if (Thread.currentThread().isInterrupted()) {
                                throw new RTInterruptedException("Interrupted while handling results : " + query);
                            }
                            if (h == null) {
                                results.add(null);
                            } else {
                                ResultSet resultSet = stmt.getResultSet();
                                results.add(h.handle(resultSet));
                                count += SQLResultSet.getRowProcessedCount(resultSet);
                            }
                            stmt.getMoreResults();
                        }
                        afterHandle = System.nanoTime();
                    }
                    SQLRequestLog.log(query, "executeMultiple", conn, timeMs, time, afterCache, afterQueryInfo, afterExecute, afterHandle, System.nanoTime(), count);
                    return null;
                }
            });
        } else {
            sysRoot.getDataSource().useConnection(new ConnectionHandlerNoSetup<Object, SQLException>(){

                @Override
                public Object handle(SQLDataSource ds) throws SQLException {
                    int i = 0;
                    while (i < size) {
                        ResultSetHandler rsh = (ResultSetHandler)handlers.get(i);
                        results.add(sysRoot.getDataSource().execute((String)queries.get(i), rsh == null ? null : new IResultSetHandler(rsh, false)));
                        ++i;
                    }
                    return null;
                }
            });
        }
        return results;
    }

    public static interface SQLFactory<T> {
        public T create() throws SQLException;
    }
}

