/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.jcip.annotations.GuardedBy;
import org.h2.api.Trigger;
import org.h2.util.StringUtils;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.utils.CollectionUtils;

public class PartialUniqueTrigger
implements Trigger {
    private final List<String> columns;
    private final String where;
    @GuardedBy(value="this")
    private int[] indexes;
    @GuardedBy(value="this")
    private SQLName tableName = null;
    @GuardedBy(value="this")
    private String triggerName = null;

    public PartialUniqueTrigger(List<String> columns, String where) {
        this.columns = Collections.unmodifiableList(new ArrayList<String>(columns));
        this.indexes = null;
        if (where == null) {
            throw new IllegalArgumentException("Should be using a real index");
        }
        this.where = where;
    }

    public final List<String> getColumns() {
        return this.columns;
    }

    public final String getWhere() {
        return this.where;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Connection conn, String schemaName, String triggerName, String tableName, boolean before, int type) throws SQLException {
        if (before) {
            throw new IllegalArgumentException("Only after is supported");
        }
        if (type == 8) {
            throw new IllegalArgumentException("Only DML is supported");
        }
        PartialUniqueTrigger partialUniqueTrigger = this;
        synchronized (partialUniqueTrigger) {
            this.tableName = new SQLName(schemaName, tableName);
            this.triggerName = triggerName;
            this.indexes = null;
        }
    }

    public synchronized int[] getIndexes(Connection conn) throws SQLException {
        if (this.indexes == null) {
            HashSet<String> toFind = new HashSet<String>(this.columns);
            if (toFind.size() < this.columns.size()) {
                throw new IllegalStateException("Duplicate columns : " + this.columns);
            }
            this.indexes = new int[this.columns.size()];
            try (ResultSet rs = conn.getMetaData().getColumns(null, this.tableName.getFirst(), this.tableName.getName(), null);){
                int i = 0;
                while (rs.next()) {
                    String column = rs.getString("COLUMN_NAME");
                    int index = this.columns.indexOf(column);
                    if (index >= 0) {
                        toFind.remove(column);
                        this.indexes[index] = i;
                    }
                    ++i;
                }
            }
            if (!toFind.isEmpty()) {
                throw new IllegalStateException("Columns not found : " + toFind);
            }
        }
        return this.indexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
        Number count;
        int[] indexes;
        String triggerName;
        SQLName name;
        PartialUniqueTrigger partialUniqueTrigger = this;
        synchronized (partialUniqueTrigger) {
            name = this.tableName;
            triggerName = this.triggerName;
            indexes = this.getIndexes(conn);
        }
        int stop = indexes.length;
        ArrayList<String> whereList = new ArrayList<String>(stop + 1);
        whereList.add(this.where);
        ArrayList<Object> newValues = new ArrayList<Object>(stop);
        int i = 0;
        while (i < stop) {
            int index = indexes[i];
            Object newValue = newRow[index];
            if (newValue == null) {
                return;
            }
            String string = this.columns.get(i);
            whereList.add(String.valueOf(StringUtils.quoteIdentifier(string)) + " = ?");
            newValues.add(newValue);
            ++i;
        }
        try (PreparedStatement stmt = conn.prepareStatement("SELECT COUNT(*) from " + name + " where " + CollectionUtils.join(whereList, " and "), 2);){
            int i2 = 1;
            for (Object e : newValues) {
                stmt.setObject(i2, e);
                ++i2;
            }
            ResultSet resultSet = stmt.executeQuery();
            count = (Number)SQLDataSource.SCALAR_HANDLER.handle(resultSet);
            resultSet.close();
        }
        if (count.intValue() > 1) {
            throw new SQLException("Duplicate entries for " + triggerName + " on " + this.columns + " : " + newValues, "23505");
        }
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public void remove() throws SQLException {
    }
}

