/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.openconcerto.sql.changer.Change;
import org.openconcerto.sql.changer.Convert;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeBase;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;

public class ConvertisseurBase
extends ChangeBase {
    public void dissociateIDs() throws SQLException {
        int offset = 0;
        this.getBase().getDataSource().getConnection().setAutoCommit(false);
        for (SQLTable t : this.getBase().getTables()) {
            if (t.getKey() == null) continue;
            this.mvIDs(t, offset, offset + 1);
            offset += 10000000;
        }
    }

    private void mvIDs(SQLTable t, int idOffset, int undefID) throws SQLException {
        if (idOffset == 0) {
            System.err.println("0 id offset for " + t);
        } else if (t.isRowable()) {
            ArrayList<String> statements = new ArrayList<String>();
            statements.add("SET FOREIGN_KEY_CHECKS=0");
            HashSet<SQLField> keys = new HashSet<SQLField>(this.getBase().getGraph().getReferentKeys(t));
            keys.add(t.getKey());
            for (SQLField refKey : keys) {
                String update = "UPDATE " + refKey.getTable().getName() + " SET " + refKey.getName() + "=" + refKey.getName() + "+ (" + idOffset + ")";
                statements.add(update);
                String alter = "ALTER TABLE " + SQLBase.quoteIdentifier(refKey.getTable().getName()) + " MODIFY COLUMN " + SQLBase.quoteIdentifier(refKey.getName()) + " ";
                alter = refKey != t.getKey() ? String.valueOf(alter) + this.getSyntax().getIDType() + " DEFAULT " + undefID : String.valueOf(alter) + this.getSyntax().getPrimaryIDDefinition();
                statements.add(alter);
            }
            statements.add("SET FOREIGN_KEY_CHECKS=1");
            System.err.println(CollectionUtils.join(statements, "\n"));
            Statement stmt = this.getBase().getDataSource().getConnection().createStatement();
            for (String s : statements) {
                stmt.addBatch(s);
            }
            stmt.executeBatch();
            this.getBase().getDataSource().getConnection().commit();
        }
    }

    public void associateIDs() throws SQLException {
        boolean undefinedID = true;
        this.getBase().getDataSource().getConnection().setAutoCommit(false);
        for (SQLTable t : this.getBase().getTables()) {
            int offset = t.getUndefinedID();
            this.mvIDs(t, -offset + 1, 1);
        }
    }

    public final void floatToDecimal() {
        for (String tn : this.getBase().getTableNames()) {
            this.floatToDecimal(tn);
        }
    }

    public final void floatToDecimal(String tableName) {
        SQLTable t = this.getBase().getTable(tableName);
        System.out.print(String.valueOf(tableName) + "... ");
        HashSet<Class> virgule = new HashSet<Class>();
        virgule.add(Float.class);
        virgule.add(Double.class);
        for (SQLField f : t.getLocalContentFields()) {
            if (!virgule.contains(f.getType().getJavaType())) continue;
            System.out.print(f);
            SQLSelect sel = new SQLSelect(t.getBase(), true).addSelect(f, "max");
            double max = ((Number)this.getBase().getDataSource().executeScalar(sel.asString())).doubleValue();
            int maxIntLength = DecimalUtils.intDigits(BigDecimal.valueOf(max));
            int defaultIntPart = 8;
            int intPart = maxIntLength <= 8 ? 8 : maxIntLength;
            String type = this.getSyntax().getDecimalIntPart(intPart, 8);
            AlterTable alter = new AlterTable(f.getTable());
            alter.alterColumn(f.getName(), Collections.singleton(SQLField.Properties.TYPE), type, null, null);
            this.getBase().getDataSource().execute(alter.asString());
        }
        System.out.println(" done");
    }

    public ConvertisseurBase(DBRoot root) {
        super(root);
    }

    public ConvertisseurBase() throws IOException {
    }

    @Override
    protected Change getChange() {
        return new Convert();
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("usage: ConvertisseurBase convertisseur...");
            System.exit(0);
        }
        ConvertisseurBase conv = new ConvertisseurBase();
        conv.call(args);
    }
}

