/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.utils.Copy;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.ReloadPanel;
import org.openconcerto.ui.VFlowLayout;
import org.openconcerto.ui.preferences.BackupProps;
import org.openconcerto.utils.Backup;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;

public class BackupPanel
extends JPanel
implements ActionListener {
    public static final String RIGHT_CODE = "BACKUP";
    private final DateFormat format = new SimpleDateFormat("EEEE", TM.getTM().getTranslationsLocale());
    private JProgressBar barDB = new JProgressBar();
    private JTextField textDest = new JTextField();
    private JButton buttonBackup = new JButton(TM.getTM().translate("backup", new Object[0]));
    private JButton buttonBrowse = new JButton("...");
    private JLabel labelErrors = new JLabel(" ");
    private JTextComponent labelLastBackup = new JTextArea();
    private JLabel labelState = new JLabelBold(" ");
    JButton buttonClose;
    private List<String> listDb;
    private List<File> dirs2save;
    private boolean closed = false;
    private boolean autoClose = false;
    private ReloadPanel reloadPanel = new ReloadPanel();
    BackupProps props;
    Thread t;
    private int seconde = 7;

    public BackupPanel(List<String> listDB, List<File> dirs2Save, boolean startNow, BackupProps props) {
        super(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.props = props;
        Insets defaultInsets = new Insets(2, 2, 1, 2);
        Insets separatorInsets = new Insets(12, 2, 1, 2);
        this.listDb = listDB;
        if (dirs2Save == null) {
            throw new NullPointerException("Null dirs");
        }
        this.dirs2save = dirs2Save;
        JPanel topPanel = new JPanel(new VFlowLayout(1, 4, 2, true));
        topPanel.setBackground(Color.white);
        topPanel.add(new JLabelBold(TM.getTM().translate("backup", new Object[0])));
        topPanel.add(this.labelLastBackup);
        this.labelLastBackup.setEditable(false);
        this.labelLastBackup.setFont(this.labelErrors.getFont());
        this.updateLastBackup();
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)topPanel, c);
        ++c.gridy;
        this.add((Component)new JSeparator(), c);
        JLabelBold sep1 = new JLabelBold(TM.getTM().translate("location", new Object[0]));
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.insets = DefaultGridBagConstraints.getDefaultInsets();
        this.add((Component)sep1, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        JPanel panelEmplacement = new JPanel(new FlowLayout(0, 0, 0));
        this.textDest.setEditable(false);
        this.textDest.setBackground(Color.white);
        c.gridwidth = startNow ? 0 : 1;
        this.add((Component)this.textDest, c);
        this.textDest.setText(props.getDestination());
        if (!startNow) {
            ++c.gridx;
            c.weightx = 0.0;
            this.add((Component)this.buttonBrowse, c);
        }
        this.add((Component)panelEmplacement, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 0;
        this.add((Component)new JLabel(TM.getTM().translate("backupPanel.differentDisks", new Object[0])), c);
        JLabelBold sep = new JLabelBold(TM.getTM().translate("backupPanel.progress", new Object[0]));
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.insets = separatorInsets;
        this.add((Component)sep, c);
        c.weightx = 1.0;
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        c.insets = defaultInsets;
        c.gridwidth = 1;
        this.add((Component)this.barDB, c);
        this.barDB.setMinimum(0);
        this.barDB.setMaximum(2 + this.dirs2save.size());
        ++c.gridx;
        c.weightx = 0.0;
        this.reloadPanel.setMode(2);
        this.add((Component)this.reloadPanel, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)this.labelErrors, c);
        int errors = props.getErrors();
        if (errors > 0) {
            this.labelErrors.setText(TM.getTM().translate("backupPanel.errorsOnLastBackup", new Object[0]));
        }
        c.gridwidth = 0;
        ++c.gridy;
        this.add((Component)this.labelState, c);
        c.fill = 0;
        c.anchor = 14;
        ++c.gridy;
        c.weighty = 1.0;
        JPanel panelButton = new JPanel();
        this.buttonClose = new JButton(TM.getTM().translate("close", new Object[0]));
        boolean canBackup = UserRightsManager.getCurrentUserRights().haveRight(RIGHT_CODE);
        this.buttonBackup.setEnabled(canBackup);
        if (!startNow || !canBackup) {
            panelButton.add(this.buttonBackup);
        }
        panelButton.add(this.buttonClose);
        this.add((Component)panelButton, c);
        this.buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BackupPanel.this.autoClose) {
                    BackupPanel.this.closed = true;
                } else {
                    BackupPanel.this.closed = true;
                    ((Window)SwingUtilities.getRoot(BackupPanel.this)).dispose();
                    BackupPanel.this.doOnClose();
                }
            }
        });
        this.buttonBackup.addActionListener(this);
        this.buttonBrowse.addActionListener(this);
        if (startNow && this.textDest.getText().trim().length() > 0) {
            this.sauvegarde();
        }
    }

    protected void updateLastBackup() {
        Date lastBackup = this.props.getLastBackup();
        if (lastBackup != null) {
            this.labelLastBackup.setText(TM.getTM().trM("backupPanel.lastBackup", "date", lastBackup, "destination", this.props.getProperty("LastBackupDestination")));
        } else {
            this.labelLastBackup.setText("");
        }
    }

    public void doOnClose() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBrowse) {
            JFileChooser choose = new JFileChooser();
            choose.setFileSelectionMode(1);
            if (choose.showDialog(this, TM.getTM().translate("choose", new Object[0])) == 0) {
                File selectedFile = choose.getSelectedFile();
                String absolutePath = selectedFile.getAbsolutePath();
                this.textDest.setText(absolutePath);
                this.props.setDestination(absolutePath);
                this.props.store();
            }
        } else if (e.getSource() == this.buttonBackup) {
            this.sauvegarde();
        }
    }

    public final void sauvegarde() {
        if (!this.buttonBackup.isEnabled()) {
            return;
        }
        assert (UserRightsManager.getCurrentUserRights().haveRight(RIGHT_CODE));
        this.barDB.setStringPainted(false);
        this.buttonBackup.setEnabled(false);
        this.labelState.setText(TM.getTM().translate("backupPanel.inProgress", new Object[0]));
        this.reloadPanel.setMode(0);
        this.barDB.setValue(1);
        String dest = this.textDest.getText();
        File fTmp = new File(dest, Configuration.getInstance().getAppName());
        final File fDest = new File(fTmp, this.format.format(new Date()));
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block15: {
                    try {
                        if (!fDest.exists() && !fDest.mkdirs()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(BackupPanel.this, TM.getTM().translate("backupPanel.createFolderError", new Object[0]));
                                }
                            });
                            break block15;
                        }
                        File testFileCreate = new File(fDest, "testrw");
                        try {
                            if (!testFileCreate.createNewFile()) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(BackupPanel.this, TM.getTM().translate("backupPanel.folderRightsError", new Object[0]));
                                        BackupPanel.this.barDB.setValue(0);
                                    }
                                });
                            } else {
                                testFileCreate.delete();
                            }
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(BackupPanel.this, TM.getTM().translate("backupPanel.folderRightsError", new Object[0]));
                                    BackupPanel.this.barDB.setValue(0);
                                }
                            });
                        }
                        int errors = 0;
                        BackupPanel.this.props.setProperty("LastBackupDestination", BackupPanel.this.textDest.getText());
                        if (BackupPanel.this.listDb == null || BackupPanel.this.listDb.size() > 0) {
                            DBRoot root = Configuration.getInstance().getRoot();
                            DBSystemRoot sysRoot = root.getDBSystemRoot();
                            SQLSystem system = sysRoot.getServer().getSQLSystem();
                            if (system == SQLSystem.H2) {
                                sysRoot.getDataSource().execute("backup to " + root.getBase().quoteString(new File(fDest, "Base.zip").getAbsolutePath()));
                            } else {
                                File fBase = new File(fDest, "Base");
                                try {
                                    Copy copy = new Copy(true, fBase, Copy.FileExistsMode.DELETE, sysRoot, false, false);
                                    Collection<String> rootsOrigin = BackupPanel.this.listDb == null ? sysRoot.getChildrenNames() : BackupPanel.this.listDb;
                                    copy.applyTo(null, BackupPanel.this.listDb == null ? null : CollectionUtils.createMap(BackupPanel.this.listDb), null);
                                    sysRoot.setRootsToMap(rootsOrigin);
                                    sysRoot.reload();
                                }
                                catch (SQLException e) {
                                    e.printStackTrace();
                                    ++errors;
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    ++errors;
                                }
                            }
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BackupPanel.this.barDB.setValue(2);
                            }
                        });
                        if (BackupPanel.this.dirs2save != null) {
                            Backup backup = new Backup(fDest);
                            int i = 1;
                            for (File f : BackupPanel.this.dirs2save) {
                                errors += backup.applyTo(f);
                                final int tmp = i + 2;
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        BackupPanel.this.barDB.setValue(tmp);
                                    }
                                });
                                ++i;
                            }
                            backup.close();
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                            }
                        });
                        BackupPanel.this.props.setLastBackup(new Date());
                        BackupPanel.this.props.setErrors(errors);
                        BackupPanel.this.props.store();
                        final int backupErrors = errors;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (backupErrors > 0) {
                                    BackupPanel.this.labelErrors.setText(TM.getTM().translate("backupPanel.errorsOnLastBackup", new Object[0]));
                                    BackupPanel.this.labelState.setText(TM.getTM().translate("backupPanel.endFail", new Object[0]));
                                    BackupPanel.this.reloadPanel.setMode(1);
                                } else {
                                    BackupPanel.this.labelErrors.setText("");
                                    BackupPanel.this.labelState.setText(TM.getTM().translate("backupPanel.endSuccess", new Object[0]));
                                    BackupPanel.this.reloadPanel.setMode(2);
                                    BackupPanel.this.closeAfter5Secondes();
                                }
                                BackupPanel.this.updateLastBackup();
                                BackupPanel.this.buttonBackup.setEnabled(true);
                            }
                        });
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle(BackupPanel.this, TM.getTM().translate("backupPanel.failed", new Object[0]), e);
                    }
                }
            }
        });
        thread.start();
    }

    public synchronized void closeAfter5Secondes() {
        if (this.t == null) {
            this.t = new Thread(){

                @Override
                public void run() {
                    BackupPanel.this.autoClose = true;
                    BackupPanel.this.seconde = 7;
                    while (BackupPanel.this.seconde > 0 && !BackupPanel.this.closed) {
                        final int rest = BackupPanel.this.seconde;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                (this).BackupPanel.this.buttonClose.setText(TM.getTM().translate("backupPanel.closingIn", rest));
                            }
                        });
                        BackupPanel backupPanel = BackupPanel.this;
                        backupPanel.seconde = backupPanel.seconde - 1;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    BackupPanel.this.autoClose = false;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            (this).BackupPanel.this.buttonClose.setText(TM.getTM().translate("close", new Object[0]));
                        }
                    });
                    if (!BackupPanel.this.closed) {
                        ((Window)SwingUtilities.getRoot(BackupPanel.this)).dispose();
                        BackupPanel.this.doOnClose();
                    }
                    BackupPanel.this.closed = false;
                }
            };
            this.t.start();
        } else {
            this.seconde = 7;
        }
    }
}

