/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.JListSQLTablePanel;
import org.openconcerto.sql.users.rights.UserRightSQLComponent;
import org.openconcerto.sql.users.rights.UserRightSQLElement;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.ListeModifyPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.cc.IClosure;

public class UserRightsPanel
extends JPanel {
    private final JListSQLTablePanel list;
    private final ListeModifyPanel modifPanel;

    public UserRightsPanel() {
        this(Configuration.getInstance().getDirectory());
    }

    public UserRightsPanel(SQLElementDirectory dir) {
        super(new GridBagLayout());
        this.modifPanel = new ListeModifyPanel(dir.getElement(UserRightSQLElement.class)){

            @Override
            protected void handleAction(JButton source, ActionEvent evt) {
                super.handleAction(source, evt);
                if (source == this.buttonAjouter) {
                    this.getAddComp().resetValue();
                }
            }
        };
        this.modifPanel.setDeaf(true);
        this.modifPanel.setSearchFullMode(false);
        this.modifPanel.getListe().setSortingEnabled(false);
        SQLTable table = this.getTable().getForeignTable("ID_USER_COMMON");
        SQLElement usersElem = dir.getElement(table);
        this.list = new JListSQLTablePanel(JListSQLTablePanel.createComboRequest(usersElem, true), TM.tr("rightsPanel.defaultRights", new Object[0]));
        if (!UserRightsManager.getCurrentUserRights().isSuperUser()) {
            this.list.getModel().setWhere(new Where((FieldRef)table.getField("SUPERUSER"), "=", (Object)false));
        }
        this.list.getModel().setItemCustomizer(new IClosure<IComboSelectionItem>(){

            @Override
            public void executeChecked(IComboSelectionItem input) {
                if (input.getId() == UserManager.getUserID()) {
                    input.setFlag(3);
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                UserRightsPanel.this.updateListFromSelection();
            }
        });
        this.updateListFromSelection();
        JPanel listePanel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.gridwidth = 0;
        listePanel.add((Component)new JLabel(TM.getInstance().trM("element.list", "element", usersElem.getName())), c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        ++c.gridy;
        c.fill = 1;
        listePanel.add((Component)this.list, c);
        JPanel panelDroits = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
        c2.gridwidth = 0;
        panelDroits.add((Component)new JLabel(TM.tr("rights", new Object[0])), c2);
        ++c2.gridy;
        c2.weightx = 1.0;
        c2.weighty = 0.7;
        c2.fill = 1;
        panelDroits.add((Component)new JScrollPane(this.modifPanel), c2);
        JSplitPane pane = new JSplitPane(1, listePanel, panelDroits);
        GridBagConstraints c3 = new GridBagConstraints();
        c3.weightx = 1.0;
        c3.weighty = 1.0;
        c3.fill = 1;
        this.add((Component)pane, c3);
    }

    private void updateListFromSelection() {
        int selectedIndex = this.list.getSelectedIndex();
        boolean b = selectedIndex >= 0;
        ListSQLRequest req = this.modifPanel.getListe().getRequest();
        int userID = b ? this.list.getModel().getRowAt(selectedIndex).getID() : this.list.getModel().getTable().getUndefinedID();
        req.setWhere(new Where((FieldRef)req.getPrimaryTable().getField("ID_USER_COMMON"), "=", userID));
        ((UserRightSQLComponent)this.modifPanel.getModifComp()).setUserID(userID);
        ((UserRightSQLComponent)this.modifPanel.getAddComp()).setUserID(userID);
    }

    public final SQLTable getTable() {
        return this.modifPanel.getElement().getTable();
    }
}

