/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.RightEditor;
import org.openconcerto.sql.users.rights.RightEditorManager;
import org.openconcerto.sql.users.rights.TableAllRights;
import org.openconcerto.ui.component.combo.ISearchableCombo;
import org.openconcerto.utils.i18n.Grammar;
import org.openconcerto.utils.model.DefaultIMutableListModel;

public class SQLTableRightEditor
implements RightEditor {
    @Override
    public void setValue(String object, DBRoot root, SQLElementDirectory directory, JComponent editorComponent) {
        ((ISearchableCombo)editorComponent).setValue(SQLTableComboItem.createFromString(object, root, directory));
    }

    @Override
    public JComponent getRightEditor(String right, DBRoot root, SQLElementDirectory directory, final JTextField fieldObject) {
        final ISearchableCombo comboMenu = new ISearchableCombo();
        DefaultIMutableListModel comboItems = new DefaultIMutableListModel();
        Set<SQLTable> set = root.getTables();
        ArrayList<SQLTableComboItem> result = new ArrayList<SQLTableComboItem>(set.size());
        result.add(SQLTableComboItem.createFromTable(null));
        for (SQLTable table : set) {
            SQLElement elt = directory.getElement(table);
            result.add(SQLTableComboItem.create(table, elt));
        }
        comboItems.addAll(result);
        comboMenu.initCache(comboItems);
        comboMenu.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SQLTableComboItem selectedItem = (SQLTableComboItem)comboMenu.getSelectedItem();
                if (selectedItem != null) {
                    fieldObject.setText(selectedItem.getValue());
                }
            }
        });
        return comboMenu;
    }

    public static void register() {
        SQLTableRightEditor editor = new SQLTableRightEditor();
        for (String code : TableAllRights.getCodes()) {
            RightEditorManager.getInstance().register(code, editor);
        }
    }

    public static class SQLTableComboItem {
        private final String value;
        private final String label;

        public static SQLTableComboItem create(SQLTable t, SQLElement elt) {
            assert (elt == null || elt.getTable() == t);
            return elt != null ? SQLTableComboItem.createFromElement(elt) : SQLTableComboItem.createFromTable(t);
        }

        public static SQLTableComboItem createFromElement(SQLElement elt) {
            return new SQLTableComboItem(elt.getTable(), elt.getName().getVariant(Grammar.SINGULAR));
        }

        public static SQLTableComboItem createFromTable(SQLTable t) {
            return new SQLTableComboItem(t, t == null ? TM.tr("rights.allTables", new Object[0]) : t.getName());
        }

        public static SQLTableComboItem createFromString(String s, DBRoot r, SQLElementDirectory dir) {
            if (s == null) {
                return SQLTableComboItem.createFromTable(null);
            }
            SQLName n = SQLName.parse(s);
            if (n.getItemCount() != 1) {
                throw new IllegalArgumentException("Not 1 item : " + n);
            }
            SQLTable t = r.findTable(n.getName());
            if (t == null) {
                return new SQLTableComboItem(s, n.getName());
            }
            return SQLTableComboItem.create(t, dir.getElement(t));
        }

        protected SQLTableComboItem(SQLTable t, String label) {
            this(TableAllRights.tableToString(t, false), label);
        }

        protected SQLTableComboItem(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.label;
        }
    }
}

