/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ConfSQLElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.itemview.SimpleRowItemView;
import org.openconcerto.sql.ui.Login;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.QuickAssignPanel;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.ISpinner;
import org.openconcerto.ui.ISpinnerIntegerModel;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.ui.valuewrapper.TextValueWrapper;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.i18n.I18nUtils;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class UserCommonSQLElement
extends ConfSQLElement {
    public static final String LEGACY_PASSWORDS = "org.openconcerto.sql.legacyPasswords";
    private final boolean familyNameFirst;

    public UserCommonSQLElement() {
        super("USER_COMMON");
        this.setL18nPackageName(I18nUtils.getPackageName(TM.class));
        this.familyNameFirst = false;
    }

    public UserCommonSQLElement(DBRoot root, boolean familyNameFirst) {
        super(root.findTable("USER_COMMON"));
        this.setL18nPackageName(I18nUtils.getPackageName(TM.class));
        this.familyNameFirst = familyNameFirst;
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>(5);
        if (this.familyNameFirst) {
            l.add("NOM");
            l.add("PRENOM");
        } else {
            l.add("PRENOM");
            l.add("NOM");
        }
        l.add("LOGIN");
        if (this.getTable().contains("DISABLED")) {
            l.add("DISABLED");
        }
        if (this.getTable().contains("OUT")) {
            l.add("OUT");
        }
        return l;
    }

    @Override
    protected synchronized void _initTableSource(SQLTableModelSource res) {
        super._initTableSource(res);
        for (SQLTableModelColumn col : res.getColumns()) {
            if (!col.getValueClass().equals(String.class)) continue;
            col.setRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    int targetStyle;
                    JLabel res = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    boolean isCurrentUser = ITableModel.getLine(table.getModel(), row).getRow().getID() == UserManager.getUserID();
                    int n = targetStyle = isCurrentUser ? 1 : 0;
                    if ((res.getFont().getStyle() & targetStyle) == 0) {
                        res.setFont(res.getFont().deriveFont(targetStyle));
                    }
                    return res;
                }
            });
        }
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>(2);
        if (this.familyNameFirst) {
            l.add("NOM");
            l.add("PRENOM");
        } else {
            l.add("PRENOM");
            l.add("NOM");
        }
        return l;
    }

    @Override
    protected void _initComboRequest(ComboSQLRequest req) {
        super._initComboRequest(req);
        req.setFieldSeparator(" ");
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, new String[]{"PRENOM", "NOM"});
    }

    @Override
    public SQLComponent createComponent() {
        return new UserSQLComponent(this);
    }

    protected static class UserSQLComponent
    extends BaseSQLComponent {
        private JPasswordField passField;
        private JPasswordField passFieldConfirm;
        private JPanel panelWarning;
        private final SQLElement accessSocieteElem;
        private QuickAssignPanel table;
        private final JTextField encryptedPass = new JTextField();
        private JCheckBox noCompanyLimitCheckBox;

        protected UserSQLComponent(SQLElement element) {
            super(element);
            SQLTable t = this.getTable().getDBSystemRoot().getGraph().findReferentTable(this.getTable(), "ACCES_SOCIETE", new String[0]);
            this.accessSocieteElem = t == null ? null : this.getDirectory().getElement(t);
        }

        protected final JPasswordField getPassField() {
            return this.passField;
        }

        protected final JPasswordField getPassFieldConfirm() {
            return this.passFieldConfirm;
        }

        @Override
        public void addViews() {
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(0, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 2;
            c.anchor = 17;
            this.panelWarning = new JPanel(new GridBagLayout());
            this.panelWarning.setBorder(BorderFactory.createEmptyBorder());
            JLabelWarning labelWarning = new JLabelWarning();
            this.panelWarning.add((Component)labelWarning, c);
            JLabel labelTextWarning = new JLabel(TM.tr("user.passwordsDontMatch.short", new Object[0]));
            ++c.gridx;
            this.panelWarning.add((Component)labelTextWarning, c);
            GridBagLayout layout = new GridBagLayout();
            this.setLayout(layout);
            c.gridx = 0;
            c.insets = new Insets(2, 2, 1, 2);
            JLabel labelLogin = new JLabel(this.getLabelFor("LOGIN"));
            labelLogin.setHorizontalAlignment(4);
            this.add((Component)labelLogin, c);
            JTextField textLogin = new JTextField();
            ++c.gridx;
            DefaultGridBagConstraints.lockMinimumSize(textLogin);
            c.weightx = 1.0;
            this.add((Component)textLogin, c);
            c.gridwidth = 0;
            ++c.gridx;
            c.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.panelWarning, c);
            this.panelWarning.setVisible(false);
            ++c.gridy;
            c.gridwidth = 1;
            c.gridx = 0;
            c.weightx = 0.0;
            c.insets = new Insets(2, 2, 1, 2);
            JLabel labelPass = new JLabel(this.getLabelFor("PASSWORD"));
            labelPass.setHorizontalAlignment(4);
            this.add((Component)labelPass, c);
            this.passField = new JPasswordField(15);
            ++c.gridx;
            c.weightx = 1.0;
            DefaultGridBagConstraints.lockMinimumSize(this.getPassField());
            this.add((Component)this.getPassField(), c);
            ++c.gridx;
            c.weightx = 0.0;
            JLabel labelConfirmationPass = new JLabel(this.getLabelFor("PASSWORD_CONFIRM"));
            labelConfirmationPass.setHorizontalAlignment(4);
            this.add((Component)labelConfirmationPass, c);
            this.passFieldConfirm = new JPasswordField(15);
            ++c.gridx;
            c.weightx = 1.0;
            DefaultGridBagConstraints.lockMinimumSize(this.getPassFieldConfirm());
            this.add((Component)this.getPassFieldConfirm(), c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            JLabel labelNom = new JLabel(this.getLabelFor("NOM"));
            labelNom.setHorizontalAlignment(4);
            this.add((Component)labelNom, c);
            JTextField textNom = new JTextField();
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)textNom, c);
            ++c.gridx;
            c.weightx = 0.0;
            JLabel labelPrenom = new JLabel(this.getLabelFor("PRENOM"));
            labelPrenom.setHorizontalAlignment(4);
            this.add((Component)labelPrenom, c);
            JTextField textPrenom = new JTextField();
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)textPrenom, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            JLabel labelSurnom = new JLabel(this.getLabelFor("SURNOM"));
            labelSurnom.setHorizontalAlignment(4);
            this.add((Component)labelSurnom, c);
            JTextField textSurnom = new JTextField();
            ++c.gridx;
            c.weightx = 1.0;
            this.add((Component)textSurnom, c);
            if (this.getTable().contains("ADMIN")) {
                JCheckBox checkAdmin = new JCheckBox(this.getLabelFor("ADMIN"));
                ++c.gridx;
                c.gridwidth = 0;
                c.weightx = 0.0;
                this.add((Component)checkAdmin, c);
                this.addView(checkAdmin, "ADMIN");
            }
            ++c.gridy;
            c.gridwidth = 1;
            c.gridx = 0;
            c.weightx = 0.0;
            if (this.getTable().contains("MAIL")) {
                JLabel labelMail = new JLabel(this.getLabelFor("MAIL"));
                labelMail.setHorizontalAlignment(4);
                c.anchor = 18;
                this.add((Component)labelMail, c);
                ++c.gridx;
                JTextField textMail = new JTextField();
                c.gridwidth = 1;
                c.weightx = 1.0;
                this.add((Component)textMail, c);
                this.addView(textMail, "MAIL");
            }
            if (this.getTable().contains("OUT")) {
                ++c.gridx;
                JCheckBox boxOut = new JCheckBox(this.getLabelFor("OUT"));
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.gridwidth = 0;
                this.add((Component)boxOut, c);
                this.addView(boxOut, "OUT");
            } else if (this.getTable().contains("DISABLED")) {
                ++c.gridx;
                JCheckBox boxDisabled = new JCheckBox(this.getLabelFor("DISABLED"));
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.gridwidth = 0;
                this.add((Component)boxDisabled, c);
                this.addView(boxDisabled, "DISABLED");
            }
            ++c.gridy;
            if (this.getTable().contains("TEL")) {
                c.gridx = 0;
                JLabel labelTel = new JLabel(this.getLabelFor("TEL"));
                c.gridwidth = 1;
                c.weightx = 0.0;
                this.add((Component)labelTel, c);
                JTextField fieldTel = new JTextField(20);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)fieldTel, c);
                this.addView(fieldTel, "TEL");
            }
            if (this.getTable().contains("CALENDAR_USER")) {
                c.gridx = 2;
                JCheckBox boxCalUser = new JCheckBox(this.getLabelFor("CALENDAR_USER"));
                c.weightx = 1.0;
                c.gridwidth = 0;
                this.add((Component)boxCalUser, c);
                this.addView(boxCalUser, "CALENDAR_USER");
            }
            boolean gestionHoraire = false;
            Configuration.getInstance().getAppName().startsWith("OpenConcerto");
            if (this.accessSocieteElem != null) {
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 4;
                this.add((Component)new JLabelBold("Acc\u00e9s aux soci\u00e9t\u00e9s"), c);
                ++c.gridy;
                this.noCompanyLimitCheckBox = new JCheckBox("ne pas limiter l'acc\u00e8s \u00e0 certaines soci\u00e9t\u00e9s");
                this.add((Component)this.noCompanyLimitCheckBox, c);
                ++c.gridy;
                c.weighty = 1.0;
                c.fill = 1;
                SQLElement companyElement = this.accessSocieteElem.getForeignElement("ID_SOCIETE_COMMON");
                ArrayList<SQLTableElement> tableElements = new ArrayList<SQLTableElement>();
                tableElements.add(new SQLTableElement(companyElement.getTable().getField("NOM")));
                RowValuesTableModel model = new RowValuesTableModel(companyElement, tableElements, companyElement.getTable().getKey(), false);
                this.table = new QuickAssignPanel(companyElement, "ID", model);
                this.add((Component)this.table, c);
                this.noCompanyLimitCheckBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        table.setEnabled(e.getStateChange() == 2);
                    }
                });
                this.getView("ADMIN").addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        boolean selected = evt.getNewValue() == Boolean.TRUE;
                        noCompanyLimitCheckBox.setEnabled(!selected);
                        if (selected) {
                            noCompanyLimitCheckBox.setSelected(true);
                        }
                    }
                });
                this.noCompanyLimitCheckBox.setSelected(true);
            }
            this.addRequiredSQLObject(textLogin, "LOGIN");
            this.addView(new SimpleRowItemView<String>((ValueWrapper)new TextValueWrapper(this.encryptedPass)){

                @Override
                public void setEditable(InteractionMode mode) {
                    mode.applyTo(this.getPassField());
                    mode.applyTo(this.getPassFieldConfirm());
                }
            }, "PASSWORD", (Object)"required");
            this.addSQLObject(textNom, "NOM");
            this.addSQLObject(textPrenom, "PRENOM");
            this.addSQLObject(textSurnom, "SURNOM");
            this.getPassField().getDocument().addDocumentListener(new SimpleDocumentListener(){

                @Override
                public void update(DocumentEvent e) {
                    this.updateEncrypted();
                    this.fireValidChange();
                }
            });
            this.getPassFieldConfirm().getDocument().addDocumentListener(new SimpleDocumentListener(){

                @Override
                public void update(DocumentEvent e) {
                    this.fireValidChange();
                }
            });
            this.addViews(c);
        }

        protected void addViews(GridBagConstraints c) {
        }

        private void createHalfDay(JPanel panelHoraires, GridBagConstraints cH, String label, String field, int startHour, int endHour) {
            panelHoraires.add((Component)new JLabel(label), cH);
            ++cH.gridx;
            this.createTime(panelHoraires, cH, "arriv\u00e9e", String.valueOf(field) + "_A", startHour);
            ++cH.gridy;
            cH.gridx = 1;
            this.createTime(panelHoraires, cH, "d\u00e9part", String.valueOf(field) + "_D", endHour);
            ++cH.gridy;
            cH.gridx = 0;
        }

        private void createTime(JPanel panelHoraires, GridBagConstraints cH, String label, String field, int hour) {
            panelHoraires.add((Component)new JLabel(label), cH);
            ++cH.gridx;
            ISpinner spinHourMA = this.createSpinner(panelHoraires, cH, true, hour);
            ISpinner spinMinMA = this.createSpinner(panelHoraires, cH, false, 0);
            this.addView(new SimpleRowItemView<Integer>(spinHourMA), "HEURE_" + field, null);
            this.addView(new SimpleRowItemView<Integer>(spinMinMA), "MINUTE_" + field, null);
        }

        private ISpinner createSpinner(JPanel panelHoraires, GridBagConstraints cH, boolean hour, int value) {
            ISpinnerIntegerModel modelHourMA = new ISpinnerIntegerModel(0, hour ? 23 : 59, value);
            ISpinner spinHourMA = new ISpinner(modelHourMA);
            panelHoraires.add((Component)spinHourMA.getComp(), cH);
            ++cH.gridx;
            panelHoraires.add((Component)new JLabel(hour ? "h" : "min"), cH);
            ++cH.gridx;
            return spinHourMA;
        }

        private void updateEncrypted() {
            String pass = String.valueOf(this.getPassField().getPassword());
            String dbPass = Boolean.getBoolean(UserCommonSQLElement.LEGACY_PASSWORDS) ? String.valueOf('\"') + pass + '\"' : pass;
            this.encryptedPass.setText(Login.encodePassword(dbPass));
        }

        private boolean checkValidityPassword() {
            boolean b = String.valueOf(this.getPassField().getPassword()).equalsIgnoreCase(String.valueOf(this.getPassFieldConfirm().getPassword()));
            this.panelWarning.setVisible(!b);
            return b;
        }

        @Override
        public synchronized ValidState getValidState() {
            return super.getValidState().and(ValidState.createCached(this.checkValidityPassword(), TM.tr("user.passwordsDontMatch", new Object[0])));
        }

        @Override
        public void select(final SQLRowAccessor row) {
            if (this.table != null) {
                this.table.getModel().clearRows();
            }
            if (row != null) {
                String bogusPass = "bogusPass!";
                this.getPassField().setText("bogusPass!");
                this.getPassFieldConfirm().setText("bogusPass!");
                if (this.accessSocieteElem != null) {
                    final SQLTable tableCompanyAccess = this.accessSocieteElem.getTable();
                    SQLRowValues graph = new SQLRowValues(tableCompanyAccess);
                    graph.put("ID", null);
                    graph.putRowValues("ID_SOCIETE_COMMON").put("NOM", null);
                    SQLRowValuesListFetcher f = new SQLRowValuesListFetcher(graph);
                    f.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                        @Override
                        public SQLSelect transformChecked(SQLSelect input) {
                            input.setWhere(new Where((FieldRef)tableCompanyAccess.getField("ID_USER_COMMON"), "=", row.getID()));
                            return input;
                        }
                    });
                    List<SQLRowValues> companies = f.fetch();
                    for (SQLRowValues r : companies) {
                        this.table.getModel().addRow(r.getForeign("ID_SOCIETE_COMMON").asRowValues());
                    }
                    this.noCompanyLimitCheckBox.setSelected(companies.isEmpty());
                }
            }
            super.select(row);
        }

        @Override
        public int insert(SQLRow order) {
            int id = super.insert(order);
            if (this.table != null && !this.noCompanyLimitCheckBox.isSelected()) {
                this.insertCompanyAccessForUser(id);
            }
            return id;
        }

        private void insertCompanyAccessForUser(int id) {
            SQLTable tableCompanyAccess = this.getDirectory().getElement("ACCES_SOCIETE").getTable();
            int stop = this.table.getModel().getRowCount();
            int i = 0;
            while (i < stop) {
                SQLRowValues rCompany = this.table.getModel().getRowValuesAt(i);
                SQLRowValues rAccess = new SQLRowValues(tableCompanyAccess);
                rAccess.put("ID_USER_COMMON", id);
                rAccess.put("ID_SOCIETE_COMMON", rCompany.getID());
                try {
                    rAccess.commit();
                }
                catch (SQLException e) {
                    ExceptionHandler.handle("Unable to store company access", e);
                }
                ++i;
            }
        }

        @Override
        public void update() {
            super.update();
            if (this.table != null) {
                SQLTable tableCompanyAccess = this.getDirectory().getElement("ACCES_SOCIETE").getTable();
                String query = "DELETE FROM " + tableCompanyAccess.getSQL() + " WHERE \"ID_USER_COMMON\" = " + this.getSelectedID();
                tableCompanyAccess.getDBSystemRoot().getDataSource().execute(query);
                if (!this.noCompanyLimitCheckBox.isSelected()) {
                    this.insertCompanyAccessForUser(this.getSelectedID());
                }
            }
        }
    }
}

