/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.textmenu;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openconcerto.sql.ui.textmenu.TextFieldMenuItem;
import org.openconcerto.utils.Tuple2;

public class TextFieldMenuTableModel
extends AbstractTableModel {
    List<Tuple2<TextFieldMenuItem, Boolean>> data = new ArrayList<Tuple2<TextFieldMenuItem, Boolean>>();
    private final String colName;

    public TextFieldMenuTableModel(List<TextFieldMenuItem> items, String colName) {
        this.colName = colName;
        this.fill(items);
    }

    private void fill(List<TextFieldMenuItem> items) {
        for (TextFieldMenuItem textFieldMenuItem : items) {
            this.data.add(Tuple2.create(textFieldMenuItem, textFieldMenuItem.isSelected()));
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 1) {
            return this.colName;
        }
        return "";
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    public List<Tuple2<TextFieldMenuItem, Boolean>> getItems() {
        return this.data;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Tuple2<TextFieldMenuItem, Boolean> item = this.data.get(rowIndex);
        if (columnIndex == 0) {
            return item.get1();
        }
        return item.get0().getName();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.data.set(rowIndex, new Tuple2<TextFieldMenuItem, Boolean>(this.data.get(rowIndex).get0(), (Boolean)aValue));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Tuple2<TextFieldMenuItem, Boolean> item = this.data.get(rowIndex);
        if (columnIndex == 0) {
            return item.get0().isEnabled();
        }
        return false;
    }
}

