/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLData;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.itemview.RowItemViewComponent;
import org.openconcerto.sql.utils.SQLCreateMoveableTable;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.ITextCombo;
import org.openconcerto.ui.component.ITextComboCache;

public class SQLTextCombo
extends ITextCombo
implements RowItemViewComponent {
    public static final String getTableName() {
        return "COMPLETION";
    }

    public static final String getRefFieldName() {
        return "CHAMP";
    }

    public static final String getValueFieldName() {
        return "LABEL";
    }

    public static final SQLCreateMoveableTable getCreateTable(SQLSyntax syntax) {
        SQLCreateMoveableTable createTable = new SQLCreateMoveableTable(syntax, SQLTextCombo.getTableName());
        createTable.addVarCharColumn(SQLTextCombo.getRefFieldName(), 100);
        createTable.addVarCharColumn(SQLTextCombo.getValueFieldName(), 200);
        createTable.setPrimaryKey(SQLTextCombo.getRefFieldName(), SQLTextCombo.getValueFieldName());
        return createTable;
    }

    public SQLTextCombo() {
    }

    public SQLTextCombo(boolean locked) {
        super(locked);
    }

    public SQLTextCombo(ComboLockedMode mode) {
        super(mode);
    }

    @Override
    public void init(SQLRowItemView v) {
        ITextComboCacheSQL cache;
        if (!this.hasCache() && (cache = new ITextComboCacheSQL(v.getField())).isValid()) {
            this.initCache(cache);
        }
    }

    public static abstract class AbstractComboCacheSQL
    implements ITextComboCache {
        private final SQLField f;
        protected final List<String> cache;
        private boolean loadedOnce;

        protected AbstractComboCacheSQL(SQLTable t, String fieldName) {
            this(t == null ? null : t.getField(fieldName));
        }

        protected AbstractComboCacheSQL(SQLField f) {
            this.f = f;
            this.cache = new ArrayList<String>();
            this.loadedOnce = false;
            if (!this.isValid()) {
                Log.get().warning("no completion found for " + this);
            }
        }

        protected final SQLDataSource getDS() {
            return this.f.getDBSystemRoot().getDataSource();
        }

        @Override
        public List<String> loadCache(boolean dsCache) {
            SQLSelect sel = new SQLSelect();
            sel.addSelect(this.getField());
            sel.setWhere(this.createWhere());
            sel.addFieldOrder(this.getField());
            List items = (List)this.getDS().execute(sel.asString(), new IResultSetHandler(SQLDataSource.COLUMN_LIST_HANDLER, dsCache, true){

                @Override
                public Set<? extends SQLData> getCacheModifiers() {
                    return Collections.singleton(this.getTable());
                }
            });
            this.cache.clear();
            this.cache.addAll(items);
            return this.cache;
        }

        protected final SQLTable getTable() {
            return this.getField().getTable();
        }

        protected final SQLField getField() {
            return this.f;
        }

        protected abstract Where createWhere();

        @Override
        public List<String> getCache() {
            if (!this.loadedOnce) {
                this.loadCache(true);
                this.loadedOnce = true;
            }
            return this.cache;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + " on " + this.getField();
        }
    }

    public static class ITextComboCacheExistingValues
    extends AbstractComboCacheSQL {
        public ITextComboCacheExistingValues(SQLField f) {
            super(f);
        }

        @Override
        public boolean isValid() {
            return String.class.isAssignableFrom(this.getField().getType().getJavaType());
        }

        @Override
        protected Where createWhere() {
            return null;
        }

        @Override
        public void addToCache(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void deleteFromCache(String string) {
            throw new UnsupportedOperationException();
        }
    }

    public static class ITextComboCacheSQL
    extends AbstractComboCacheSQL {
        private final String id;

        public ITextComboCacheSQL(SQLField f) {
            this(f.getDBRoot(), f.getFullName());
        }

        public ITextComboCacheSQL(DBRoot r, String id) {
            super(r.findTable(SQLTextCombo.getTableName()), SQLTextCombo.getValueFieldName());
            this.id = id;
        }

        @Override
        public final boolean isValid() {
            return this.getTable() != null;
        }

        @Override
        protected Where createWhere() {
            return new Where((FieldRef)this.getTable().getField(SQLTextCombo.getRefFieldName()), "=", (Object)this.id);
        }

        @Override
        public void addToCache(String string) {
            if (!this.cache.contains(string)) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put(SQLTextCombo.getRefFieldName(), this.id);
                m.put(SQLTextCombo.getValueFieldName(), string);
                try {
                    new SQLRowValues(this.getTable(), m).insert(true, false);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                this.cache.add(string);
            }
        }

        @Override
        public void deleteFromCache(String string) {
            Where w = new Where((FieldRef)this.getTable().getField(SQLTextCombo.getRefFieldName()), "=", (Object)this.id).and(new Where((FieldRef)this.getField(), "=", (Object)string));
            this.getDS().executeScalar("DELETE FROM " + this.getTable().getSQLName().quote() + " WHERE " + w.getClause());
            this.cache.removeAll(Collections.singleton(string));
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + "/" + this.id;
        }
    }
}

