/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.FieldExpander;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSearchMode;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.BaseFillSQLRequest;
import org.openconcerto.sql.request.ComboSQLRequestUtils;
import org.openconcerto.sql.request.FilteredFillSQLRequest;
import org.openconcerto.sql.request.SQLCache;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cache.CacheResult;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.cc.ITransformer;

@ThreadSafe
public final class ComboSQLRequest
extends FilteredFillSQLRequest
implements Cloneable {
    private static final SQLCache<CacheKey, List<IComboSelectionItem>> cache = new SQLCache(60, -1, "items of " + ComboSQLRequest.class);
    private static final String SEP_CHILD = " \u25c4 ";
    @GuardedBy(value="this")
    private static String SEP_FIELD;
    @GuardedBy(value="this")
    private static Comparator<? super IComboSelectionItem> DEFAULT_COMPARATOR;
    private final SQLElementDirectory dir;
    @GuardedBy(value="this")
    private String fieldSeparator = ComboSQLRequest.getDefaultFieldSeparator();
    @GuardedBy(value="this")
    private String undefLabel;
    @GuardedBy(value="this")
    private KeepMode keepRows;
    @GuardedBy(value="this")
    private IClosure<IComboSelectionItem> customizeItem;
    @GuardedBy(value="this")
    private Comparator<? super IComboSelectionItem> itemsOrder;

    static {
        ComboSQLRequest.setDefaultFieldSeparator(" | ");
        ComboSQLRequest.setDefaultItemsOrder(null);
    }

    public static synchronized void setDefaultFieldSeparator(String separator) {
        SEP_FIELD = separator;
    }

    public static synchronized String getDefaultFieldSeparator() {
        return SEP_FIELD;
    }

    public static synchronized void setDefaultItemsOrder(Comparator<? super IComboSelectionItem> comp) {
        DEFAULT_COMPARATOR = comp;
    }

    public static synchronized Comparator<? super IComboSelectionItem> getDefaultItemsOrder() {
        return DEFAULT_COMPARATOR;
    }

    private static final SQLElementDirectory getDirectory(SQLElementDirectory dir) {
        if (dir != null) {
            return dir;
        }
        Configuration conf = Configuration.getInstance();
        return conf == null ? null : conf.getDirectory();
    }

    private static final FieldExpander getExpander(SQLElementDirectory dir) {
        return (dir = ComboSQLRequest.getDirectory(dir)) != null ? ComboSQLRequestUtils.getShowAs(dir) : FieldExpander.getEmpty();
    }

    public ComboSQLRequest(SQLTable table, List<String> l) {
        this(table, l, null);
    }

    public ComboSQLRequest(SQLTable table, List<String> l, Where where) {
        this(table, l, where, null);
    }

    public ComboSQLRequest(SQLTable table, List<String> l, Where where, SQLElementDirectory dir) {
        this(ComboSQLRequest.computeGraph(table, l, ComboSQLRequest.getExpander(dir)), where, dir);
    }

    public ComboSQLRequest(SQLRowValues graph, Where where, SQLElementDirectory dir) {
        super(graph, where);
        this.dir = dir;
        this.undefLabel = null;
        this.keepRows = KeepMode.NONE;
        this.customizeItem = null;
        this.itemsOrder = ComboSQLRequest.getDefaultItemsOrder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ComboSQLRequest(ComboSQLRequest c, boolean freeze) {
        super(c, freeze);
        this.dir = c.dir;
        ComboSQLRequest comboSQLRequest = c;
        synchronized (comboSQLRequest) {
            this.itemsOrder = c.itemsOrder;
            this.fieldSeparator = c.fieldSeparator;
            this.undefLabel = c.undefLabel;
            this.keepRows = c.keepRows;
            this.customizeItem = c.customizeItem;
        }
    }

    private final SQLElementDirectory getDirectory() {
        return ComboSQLRequest.getDirectory(this.dir);
    }

    @Override
    public ComboSQLRequest toUnmodifiable() {
        return (ComboSQLRequest)this.toUnmodifiableP(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComboSQLRequest clone() {
        ComboSQLRequest comboSQLRequest = this;
        synchronized (comboSQLRequest) {
            return this.clone(false);
        }
    }

    @Override
    protected ComboSQLRequest clone(boolean forFreeze) {
        return new ComboSQLRequest(this, forFreeze);
    }

    public final synchronized void setUndefLabel(String undefLabel) {
        this.checkFrozen();
        this.undefLabel = undefLabel;
    }

    public final synchronized String getUndefLabel() {
        return this.undefLabel;
    }

    public final synchronized void setItemCustomizer(IClosure<IComboSelectionItem> customizeItem) {
        this.checkFrozen();
        this.customizeItem = customizeItem;
    }

    public final IComboSelectionItem getComboItem(int id) {
        List<IComboSelectionItem> res = this.getComboItems(id, null, null, null, false, false);
        return this.getSole(res, id);
    }

    public final List<IComboSelectionItem> getComboItems() {
        return this.getComboItems(true);
    }

    public final List<IComboSelectionItem> getComboItems(boolean readCache) {
        return this.getComboItems(readCache, null, null, null);
    }

    public final List<IComboSelectionItem> getComboItems(boolean readCache, List<String> searchQuery, Locale locale, Where searchForceInclude) {
        return this.getComboItems(null, searchQuery, locale, searchForceInclude, readCache, true);
    }

    private final List<IComboSelectionItem> getComboItems(Number id, List<String> searchQuery, Locale locale, Where searchForceInclude, boolean readCache, boolean writeCache) {
        SQLRowValuesListFetcher comboSelect;
        Where w = id == null ? null : new Where((FieldRef)this.getPrimaryTable().getKey(), "=", (Object)id);
        CacheKey cacheKey = this.getCacheKey(w, searchQuery, locale, searchForceInclude);
        CacheResult l = cache.check(cacheKey, readCache, writeCache, (comboSelect = cacheKey.fetcher).getGraph().getGraph().getTables());
        if (l.getState() == CacheResult.State.INTERRUPTED) {
            throw new RTInterruptedException("interrupted while waiting for the cache");
        }
        if (l.getState() == CacheResult.State.VALID) {
            return (List)l.getRes();
        }
        try {
            List<Tuple2<Path, List<FieldPath>>> ancestors = ComboSQLRequestUtils.expandGroupBy(cacheKey.graph, this.getDirectory());
            ArrayList<IComboSelectionItem> result = new ArrayList<IComboSelectionItem>();
            for (SQLRowValues vals : comboSelect.fetch(w, cacheKey.selTransformer, null)) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new RTInterruptedException("interrupted in fill");
                }
                result.add(ComboSQLRequest.createItem(vals, cacheKey, ancestors));
            }
            if (cacheKey.itemsOrder != null) {
                Collections.sort(result, cacheKey.itemsOrder);
            }
            if (writeCache) {
                cache.put(l, result);
            }
            return result;
        }
        catch (RuntimeException exn) {
            cache.removeRunning((CacheKey)((Object)l));
            throw exn;
        }
    }

    protected final CacheKey getCacheKey() {
        return this.getCacheKey(null, null, null, null);
    }

    private final synchronized CacheKey getCacheKey(Where w, List<String> searchQuery, Locale l, Where searchForceInclude) {
        return new CacheKey(this.getGraph(), this.getFetcher(), w, this.createSearchTransformer(searchQuery, l, searchForceInclude), this.fieldSeparator, this.undefLabel, this.customizeItem, this.keepRows, this.itemsOrder);
    }

    @Override
    protected final synchronized SQLSelect transformSelect(SQLSelect sel) {
        sel.setExcludeUndefined(this.getUndefLabel() == null, this.getPrimaryTable());
        return super.transformSelect(sel);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected Collection<BaseFillSQLRequest.SearchField> getDefaultSearchFields() {
        res = new ArrayList<BaseFillSQLRequest.SearchField>();
        expandGroupBy = ComboSQLRequestUtils.expandGroupBy(this.getGraph(), this.getDirectory());
        rank = 10;
        iter = expandGroupBy.listIterator(expandGroupBy.size());
        if (ComboSQLRequest.$assertionsDisabled || !iter.hasNext()) ** GOTO lbl13
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            element = iter.previous();
            for (FieldPath fp : element.get1()) {
                res.add(new BaseFillSQLRequest.SearchField(fp, SQLSearchMode.CONTAINS, rank));
            }
            rank *= 5;
lbl13:
            // 2 sources

            ** while (iter.hasPrevious())
        }
lbl14:
        // 1 sources

        return res;
    }

    @Override
    protected List<Path> getDefaultOrder() {
        List<Tuple2<Path, List<FieldPath>>> expandGroupBy = ComboSQLRequestUtils.expandGroupBy(this.getGraph(), this.getDirectory());
        ArrayList<Path> res = new ArrayList<Path>(expandGroupBy.size());
        for (Tuple2<Path, List<FieldPath>> ancestor : expandGroupBy) {
            res.add(0, ancestor.get0());
        }
        return res;
    }

    public final void setNaturalItemsOrder(boolean b) {
        this.setItemsOrder(b ? CompareUtils.naturalOrder() : null);
    }

    public final synchronized void setItemsOrder(Comparator<? super IComboSelectionItem> comp) {
        this.checkFrozen();
        this.itemsOrder = comp;
    }

    public final synchronized Comparator<? super IComboSelectionItem> getItemsOrder() {
        return this.itemsOrder;
    }

    private static final IComboSelectionItem createItem(final SQLRowValues rs, final CacheKey ck, List<Tuple2<Path, List<FieldPath>>> ancestors) {
        String desc = ck.undefLabel != null && rs.isUndefined() ? ck.undefLabel : CollectionUtils.join(ancestors, SEP_CHILD, new ITransformer<Tuple2<Path, List<FieldPath>>, Object>(){

            @Override
            public Object transformChecked(Tuple2<Path, List<FieldPath>> ancestorFields) {
                List filtered = CollectionUtils.transformAndFilter((Collection)ancestorFields.get1(), new ITransformer<FieldPath, String>(){

                    @Override
                    public String transformChecked(FieldPath input) {
                        return ComboSQLRequest.getFinalValueOf(input, rs);
                    }
                }, IPredicate.notNullPredicate(), new ArrayList());
                return CollectionUtils.join(filtered, ck.fieldSeparator);
            }
        });
        IComboSelectionItem res = ck.getKeepMode() == KeepMode.GRAPH ? new IComboSelectionItem(rs, desc) : (ck.getKeepMode() == KeepMode.ROW ? new IComboSelectionItem(rs.asRow(), desc) : new IComboSelectionItem(rs.getID(), desc));
        if (ck.customizeItem != null) {
            ck.customizeItem.executeChecked(res);
        }
        return res;
    }

    protected static String getFinalValueOf(FieldPath element, SQLRowValues rs) {
        String result = element.getString(rs);
        return result;
    }

    public final synchronized void setFieldSeparator(String string) {
        this.checkFrozen();
        this.fieldSeparator = string;
    }

    public synchronized String getSeparatorsChars() {
        return SEP_CHILD + this.fieldSeparator;
    }

    public final synchronized KeepMode getKeepMode() {
        return this.keepRows;
    }

    public final void keepRows(boolean b) {
        this.keepRows(b ? KeepMode.ROW : KeepMode.NONE);
    }

    public final synchronized void keepRows(KeepMode mode) {
        this.checkFrozen();
        this.keepRows = mode;
    }

    @Immutable
    protected static final class CacheKey {
        private final SQLRowValues graph;
        private final SQLRowValuesListFetcher fetcher;
        private final Where where;
        private final ITransformer<SQLSelect, SQLSelect> selTransformer;
        private final String select;
        private final String fieldSeparator;
        private final String undefLabel;
        private final KeepMode keepRows;
        private final IClosure<IComboSelectionItem> customizeItem;
        private final Comparator<? super IComboSelectionItem> itemsOrder;

        public CacheKey(SQLRowValues graph, SQLRowValuesListFetcher f, Where w, ITransformer<SQLSelect, SQLSelect> selTransformer, String fieldSeparator, String undefLabel, IClosure<IComboSelectionItem> c, KeepMode keepRows, Comparator<? super IComboSelectionItem> itemsOrder) {
            if (!graph.isFrozen()) {
                throw new IllegalArgumentException("Not frozen : " + graph);
            }
            this.graph = graph;
            if (f != null && !f.isFrozen()) {
                throw new IllegalArgumentException("Not frozen : " + f);
            }
            this.fetcher = f;
            this.where = w;
            this.selTransformer = selTransformer;
            this.select = this.fetcher.getReq(this.where, this.selTransformer).asString();
            this.fieldSeparator = fieldSeparator;
            this.undefLabel = undefLabel;
            this.keepRows = keepRows;
            this.customizeItem = c;
            this.itemsOrder = itemsOrder;
        }

        public final KeepMode getKeepMode() {
            return this.keepRows;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fetcher == null ? 0 : this.fetcher.hashCode());
            result = 31 * result + this.fieldSeparator.hashCode();
            result = 31 * result + this.keepRows.hashCode();
            result = 31 * result + (this.undefLabel == null ? 0 : this.undefLabel.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.keepRows == other.keepRows && this.fieldSeparator.equals(other.fieldSeparator) && CompareUtils.equals(this.undefLabel, other.undefLabel) && this.graph.getGraphFirstDifference(other.graph, true) == null && this.select.equals(other.select) && CompareUtils.equals(this.customizeItem, other.customizeItem) && CompareUtils.equals(this.itemsOrder, other.itemsOrder);
        }
    }

    public static enum KeepMode {
        NONE,
        ROW,
        GRAPH;

    }
}

