/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.navigator;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class VerticalTextColumn
extends JPanel {
    private int lastHeigh;
    private Image newImage = null;
    private Image image;
    private String title;
    private Font font = new Font("Arial Gras", 0, 16);

    public VerticalTextColumn(String title) {
        this.title = title;
        String imageName = "Images/leftbackground.png";
        URL imageURL = this.getClass().getResource("/" + imageName);
        ImageIcon icon = null;
        if (imageURL != null) {
            icon = new ImageIcon(imageURL);
        } else if (new File(imageName).exists()) {
            icon = new ImageIcon(imageName);
        }
        if (icon != null) {
            this.image = icon.getImage();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(20, 150);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(20, 800);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.computeImage();
        g.drawImage(this.newImage, 0, 0, null);
    }

    private void computeImage() {
        if (this.newImage != null && this.lastHeigh == this.getHeight()) {
            return;
        }
        this.lastHeigh = this.getHeight();
        this.newImage = this.createImage(this.getWidth(), this.getHeight());
        Graphics g = this.newImage.getGraphics();
        Rectangle r = this.getBounds();
        int height = 20;
        Graphics2D g2 = (Graphics2D)g;
        g.setFont(this.font);
        g.setColor(new Color(100, 100, 120));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.white);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        Rectangle2D re = this.font.getStringBounds(this.title, g2.getFontRenderContext());
        int x = -((int)re.getWidth()) - 20;
        int y = (int)re.getHeight() - 4;
        AffineTransform at = new AffineTransform();
        at.rotate(Math.toRadians(-90.0), 0.0, 0.0);
        g2.setTransform(at);
        g2.drawString(this.title, x, y);
    }
}

