/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;

public class SQLBackgroundTableCacheItem {
    private SQLTable table;
    private int timeout;
    private List<SQLRow> rows = new ArrayList<SQLRow>();
    private long lastReload;
    private boolean enableReloadIfTableModified = true;

    public SQLBackgroundTableCacheItem(SQLTable t, int second) {
        this.table = t;
        this.timeout = second;
        this.table.addTableModifiedListener(new SQLTableModifiedListener(){

            @Override
            public void tableModified(SQLTableEvent evt) {
                if (SQLBackgroundTableCacheItem.this.enableReloadIfTableModified) {
                    SQLBackgroundTableCacheItem.this.lastReload = 0L;
                }
                SQLBackgroundTableCacheItem.this.reloadFromDbIfNeeded();
            }
        });
    }

    public void setEnableReloadIfTableModified(boolean enableReloadIfTableModified) {
        this.enableReloadIfTableModified = enableReloadIfTableModified;
    }

    public synchronized void reloadFromDbIfNeeded() {
        long delta = System.currentTimeMillis() - this.lastReload;
        if (delta / 1000L > (long)this.timeout) {
            SQLSelect sel = new SQLSelect();
            sel.addSelectStar(this.table);
            this.rows = Collections.unmodifiableList((List)this.table.getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel, this.table)));
            this.lastReload = System.currentTimeMillis();
        }
    }

    public synchronized SQLRow getFirstRowContains(int value, SQLField field) {
        for (SQLRow r : this.rows) {
            if (r.getInt(field.getName()) != value || r.isArchived()) continue;
            return r;
        }
        return null;
    }

    public synchronized SQLRow getFirstRowContains(String value, SQLField field) {
        for (SQLRow r : this.rows) {
            if (!r.getString(field.getName()).equals(value) || r.isArchived()) continue;
            return r;
        }
        return null;
    }

    public synchronized SQLRow getRowFromId(int i) {
        return this.getFirstRowContains(i, this.table.getKey());
    }

    public synchronized List<SQLRow> getRows() {
        return this.rows;
    }

    public SQLTable getTable() {
        return this.table;
    }
}

