/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.Comparator;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CompareUtils;

public class OrderComparator
implements Comparator<SQLRowAccessor> {
    public static final OrderComparator INSTANCE = new OrderComparator(false);
    private static final OrderComparator INSTANCE_FALLBACK_TO_PK = new OrderComparator(true);
    private final boolean fallbackToPK;

    public static final Comparator<SQLRowAccessor> getFallbackToPKInstance() {
        return INSTANCE_FALLBACK_TO_PK;
    }

    private OrderComparator(boolean fallbackToPK) {
        this.fallbackToPK = fallbackToPK;
    }

    @Override
    public int compare(SQLRowAccessor r1, SQLRowAccessor r2) {
        if (r1 == r2) {
            return 0;
        }
        SQLTable t = r1.getTable();
        if (!t.equals(r2.getTable())) {
            throw new IllegalArgumentException(r1 + " and " + r2 + " are not of the same table");
        }
        if (t.isOrdered()) {
            return r1.getOrder().compareTo(r2.getOrder());
        }
        if (this.fallbackToPK) {
            if (!t.isRowable()) {
                throw new IllegalArgumentException(t + " neither ordered nor rowable");
            }
            if (r1.hasID() && r2.hasID()) {
                return CompareUtils.compareInt(r1.getID(), r2.getID());
            }
            throw new IllegalArgumentException("Missing ID");
        }
        throw new IllegalArgumentException(t + " not ordered");
    }
}

