/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.LayoutFocusTraversalPolicy;
import org.openconcerto.sql.TM;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.DocumentationEditorFrame;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.request.RowItemDesc;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.PopupMouseListener;

public abstract class UISQLComponent
extends BaseSQLComponent {
    public static final String REQUIRED_SUFFIX_PROP = "org.openconcerto.sql.requiredSuffix";
    private static final String REQ_SUFFIX = System.getProperty("org.openconcerto.sql.requiredSuffix", " *");
    private FormLayouter autoLayouter;
    private final Map<String, JComponent> labels;
    private JPanel currentPanel;
    private JTabbedPane tabbedPane;
    private final int width;
    private final int def;

    public UISQLComponent(SQLElement element) {
        this(element, 2);
    }

    public UISQLComponent(SQLElement element, int width) {
        this(element, width, 0);
    }

    public UISQLComponent(SQLElement element, int width, int def) {
        super(element);
        this.width = width;
        this.def = def;
        this.tabbedPane = null;
        this.currentPanel = this;
        this.autoLayouter = null;
        this.labels = new HashMap<String, JComponent>();
    }

    @Override
    protected void addToUI(final SQLRowItemView obj, String where) {
        JComponent added;
        RowItemDesc rivDesc = this.getRIVDesc(obj.getSQLName());
        String desc = this.getLabel(obj.getSQLName(), rivDesc);
        if (where == null) {
            where = this.getDefaultWhere(obj);
        }
        if (where == null) {
            added = this.getLayouter().add(desc, obj.getComp());
        } else if (where.equals("bordered")) {
            added = this.getLayouter().addBordered(desc, obj.getComp(), 0);
        } else if (where.equals("left")) {
            this.getLayouter().newLine();
            added = this.getLayouter().add(desc, obj.getComp(), this.getLayouter().getWidth() / 2);
        } else if (where.equals("right")) {
            added = this.getLayouter().add(desc, obj.getComp(), (this.getLayouter().getWidth() + 1) / 2);
        } else {
            int aWidth = Integer.parseInt(where);
            added = this.getLayouter().add(desc, obj.getComp(), aWidth);
        }
        this.labels.put(obj.getSQLName(), added);
        this.updateUI(obj.getSQLName(), rivDesc);
        final JPopupMenu menu = new JPopupMenu();
        menu.add(new AbstractAction(TM.tr("sqlComp.modifyDoc", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                DocumentationEditorFrame frame = new DocumentationEditorFrame(UISQLComponent.this, obj.getSQLName());
                frame.setDefaultCloseOperation(2);
                frame.setVisible(true);
            }
        });
        added.addMouseListener(new PopupMouseListener(){

            @Override
            protected JPopupMenu createPopup(MouseEvent e) {
                return e.isControlDown() ? menu : null;
            }
        });
        added.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isAltDown()) {
                    UISQLComponent.this.toggleDisplayFieldsNames();
                }
            }
        });
    }

    @Override
    protected String getLabel(String itemName, RowItemDesc desc) {
        String res = super.getLabel(itemName, desc);
        return this.getRequiredNames().contains(itemName) ? String.valueOf(res) + REQ_SUFFIX : res;
    }

    @Override
    protected void updateUI(String itemName, RowItemDesc desc) {
        super.updateUI(itemName, desc);
        this.updateUI(itemName, this.labels.get(itemName), desc);
    }

    private String getDefaultWhere(SQLRowItemView obj) {
        if (obj.getFields().size() == 1 && this.getElement().getOwnedLink(obj.getField().getName(), SQLElementLink.LinkType.COMPOSITION) != null) {
            return "bordered";
        }
        return null;
    }

    protected void addUITitle(String title) {
        this.getLayouter().add(title, null);
    }

    protected final void addTab() {
        this.addTab("G\u00e9n\u00e9ral");
    }

    protected final void addTab(String tabTitle) {
        this.addTab(tabTitle, this.width, this.def);
    }

    protected final void addTab(String tabTitle, int w, int d) {
        if (this.tabbedPane == null) {
            if (this.getComponentCount() > 0) {
                throw new IllegalStateException("you cannot create a tab after adding views");
            }
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setFocusCycleRoot(true);
            this.tabbedPane.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){
                private final JTabbedPane tab;
                {
                    this.tab = UISQLComponent.this.tabbedPane;
                }

                @Override
                public Component getComponentAfter(Container container, Component component) {
                    if (component == this.getLastComponent(this.tab)) {
                        this.tab.setSelectedIndex((this.tab.getSelectedIndex() + 1) % this.tab.getTabCount());
                        return this.getFirstComponent((Container)this.tab.getSelectedComponent());
                    }
                    return super.getComponentAfter(container, component);
                }

                @Override
                public Component getComponentBefore(Container container, Component component) {
                    if (component == this.getFirstComponent(this.tab)) {
                        int index = (this.tab.getTabCount() + this.tab.getSelectedIndex() - 1) % this.tab.getTabCount();
                        this.tab.setSelectedIndex(index);
                        return this.getLastComponent((Container)this.tab.getSelectedComponent());
                    }
                    return super.getComponentBefore(container, component);
                }

                @Override
                protected boolean accept(Component component) {
                    if (component == this.tab) {
                        return false;
                    }
                    return super.accept(component);
                }
            });
            this.setLayout(new GridLayout(1, 1));
            this.add(this.tabbedPane);
        }
        JPanel newPanel = new JPanel();
        newPanel.setOpaque(false);
        this.tabbedPane.addTab(tabTitle, newPanel);
        this.setLayouterOn(newPanel, w, d);
    }

    protected final void setLayouterOn(JPanel cont) {
        this.setLayouterOn(cont, this.width, this.def);
    }

    protected final void setLayouterOn(JPanel cont, int w, int d) {
        this.currentPanel = cont;
        this.setLayouter(w, d);
    }

    private void setLayouter(int w, int d) {
        this.autoLayouter = new FormLayouter(this.currentPanel, w, d);
        this.setAdditionalFieldsPanel(this.autoLayouter);
    }

    protected final FormLayouter getLayouter() {
        if (this.autoLayouter == null) {
            this.setLayouter(this.width, this.def);
        }
        return this.autoLayouter;
    }
}

