/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.SetMap;

public class MergeRows
extends Changer<SQLTable> {
    public static final String FIELDS_TO_COMPARE_PROP = "fieldsToCompare";
    private final Set<String> fieldsToCompare = new HashSet<String>();

    public MergeRows(DBSystemRoot b) {
        super(b);
    }

    public final void setFieldsToCompare(Collection<String> fieldsToCompare) {
        this.fieldsToCompare.clear();
        this.fieldsToCompare.addAll(fieldsToCompare);
    }

    @Override
    protected Class<? extends DBStructureItem<?>> getMaxLevel() {
        return SQLTable.class;
    }

    @Override
    public void setUpFromSystemProperties() {
        super.setUpFromSystemProperties();
        String prop = System.getProperty(FIELDS_TO_COMPARE_PROP);
        if (prop != null && prop.length() != 0) {
            this.setFieldsToCompare(Arrays.asList(prop.split(",")));
        }
    }

    protected SQLRowValues createGraph(SQLTable t) {
        SQLRowValues res = new SQLRowValues(t).putNulls(this.fieldsToCompare, false);
        if (t.isArchivable()) {
            res.putNulls(t.getArchiveField().getName());
        }
        return res;
    }

    protected SQLRowValuesListFetcher createFetcher(SQLTable t) {
        return SQLRowValuesListFetcher.create(this.createGraph(t), true);
    }

    protected boolean shouldMerge(SQLRowValues r1, SQLRowValues r2) {
        if (this.fieldsToCompare.size() == 0) {
            return false;
        }
        for (String f : this.fieldsToCompare) {
            if (this.isEqualNonEmptyValue(r1, r2, f)) continue;
            return false;
        }
        return true;
    }

    protected boolean isEqualNonEmptyValue(SQLRowAccessor r1, SQLRowAccessor r2, String f) {
        return this.isEqualValue(r1, r2, f, true);
    }

    protected boolean isEqualValue(SQLRowAccessor r1, SQLRowAccessor r2, String f, boolean nonEmpty) {
        Object normalized2;
        if (!r1.contains(f) || !r2.contains(f)) {
            throw new IllegalStateException("Missing " + f);
        }
        Object normalized1 = this.normalize(f, r1.getObject(f));
        if (!CompareUtils.equals(normalized1, normalized2 = this.normalize(f, r2.getObject(f)))) {
            return false;
        }
        return !nonEmpty || !this.isEmpty(f, normalized1) || !this.isEmpty(f, normalized2);
    }

    protected Object normalize(String fieldName, Object o) {
        if (o instanceof String) {
            return ((String)o).trim().toLowerCase();
        }
        return o;
    }

    protected boolean isEmpty(String f, Object normalized) {
        return normalized == null || "".equals(normalized);
    }

    protected void mergeFields(SQLRowValues emptyUpdateRow, List<SQLRow> rows) {
    }

    @Override
    protected void changeImpl(final SQLTable t) throws SQLException {
        if (!t.getDBSystemRoot().isMappingAllRoots()) {
            throw new IllegalStateException("Not mapping all roots means not all referent tables can be found and thus leave unarchived rows pointing to archived rows of " + t);
        }
        this.getStream().println("merging rows of " + t.getSQLName() + " using " + this.fieldsToCompare + "... ");
        SQLRowValuesListFetcher fetcher = this.createFetcher(t);
        this.getStream().println("fetcher : " + fetcher.getGraph().printGraph());
        List<SQLRowValues> rows = fetcher.fetch();
        if (rows.size() <= 1) {
            return;
        }
        ListMap<SQLRow, SQLRow> toMerge = new ListMap<SQLRow, SQLRow>();
        HashSet<SQLRow> unicity = new HashSet<SQLRow>();
        for (SQLRowValues r1 : rows) {
            Iterator<SQLRowValues> iter = rows.iterator();
            List transitiveRows = Collections.emptyList();
            boolean done = false;
            while (iter.hasNext() && !done) {
                SQLRowValues sQLRowValues = iter.next();
                SQLRow r2Row = sQLRowValues.asRow();
                boolean bl = done = sQLRowValues == r1;
                if (done || transitiveRows.contains(r2Row) || !this.shouldMerge(r1, sQLRowValues)) continue;
                toMerge.add(r2Row, r1.asRow());
                assert (unicity.add(r1.asRow()));
                transitiveRows = (List)toMerge.get(r2Row);
            }
        }
        if (toMerge.size() == 0) {
            this.getStream().println("No duplicates found");
            return;
        }
        this.getStream().println("Found " + toMerge.size() + " duplicates :");
        this.getStream().println(toMerge);
        ArrayList<List<String>> mappingRows = new ArrayList<List<String>>();
        final ArrayList<Number> toArchive = new ArrayList<Number>();
        final ArrayList<SQLRowValues> toUpdate = new ArrayList<SQLRowValues>();
        ArrayList<SQLRow> tmpDups = new ArrayList<SQLRow>(16);
        SQLRowValues tmpVals = new SQLRowValues(t);
        for (Map.Entry entry : toMerge.entrySet()) {
            SQLRow mergeDest = (SQLRow)entry.getKey();
            tmpDups.clear();
            tmpDups.add(mergeDest);
            tmpDups.addAll((Collection)entry.getValue());
            tmpVals.clear();
            this.mergeFields(tmpVals, tmpDups);
            if (tmpVals.size() > 0) {
                SQLRowValues toUpdateVals = tmpVals.deepCopy();
                toUpdateVals.setPrimaryKey(mergeDest);
                toUpdate.add(toUpdateVals);
            }
            for (SQLRow rowToMerge : (List)entry.getValue()) {
                mappingRows.add(Arrays.asList(String.valueOf(rowToMerge.getID()), String.valueOf(mergeDest.getID())));
                toArchive.add(rowToMerge.getIDNumber());
            }
        }
        this.getStream().println("To update:\n" + toUpdate);
        if (this.isDryRun()) {
            return;
        }
        String string = "mergeMapping";
        final String constantTable = this.getSyntax().getConstantTable(mappingRows, "mergeMapping", Arrays.asList("OLD_ID", "NEW_ID"));
        SQLUtils.executeAtomic(this.getDS(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                for (SQLRowValues v : toUpdate) {
                    v.commit();
                }
                SetMap<SQLTable, String> toFire = new SetMap<SQLTable, String>();
                for (Link refLink : t.getDBSystemRoot().getGraph().getReferentLinks(t)) {
                    MergeRows.this.getStream().println("updating : " + ((SQLTable)refLink.getSource()).getSQLName() + " " + refLink.getCols());
                    UpdateBuilder updateBuilder = new UpdateBuilder((SQLTable)refLink.getSource());
                    updateBuilder.addVirtualJoin(constantTable, "mergeMapping", true, "OLD_ID", refLink.getSingleField().getName());
                    updateBuilder.setFromVirtualJoinField(refLink.getSingleField().getName(), "mergeMapping", "NEW_ID");
                    MergeRows.this.getDS().execute(updateBuilder.asString());
                    toFire.add((SQLTable)refLink.getSource(), refLink.getSingleField().getName());
                }
                if (!$assertionsDisabled && !t.getDBSystemRoot().isMappingAllRoots()) {
                    throw new AssertionError((Object)"Some rows might still point to us");
                }
                UpdateBuilder archiveUpdate = new UpdateBuilder(t);
                archiveUpdate.setObject(t.getArchiveField(), (Object)1);
                archiveUpdate.setWhere(new Where(t.getKey(), toArchive));
                MergeRows.this.getStream().println("archiving : " + archiveUpdate.asString());
                MergeRows.this.getDS().execute(archiveUpdate.asString());
                toFire.add(t, t.getArchiveField().getName());
                for (Map.Entry e : toFire.entrySet()) {
                    ((SQLTable)e.getKey()).fireTableModified(-1, (Collection)e.getValue());
                }
                return null;
            }
        });
    }
}

