/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.element.JoinSQLElement;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.Constraint;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.utils.CollectionUtils;

public class JoinOrderByOwner
extends Changer<SQLTable> {
    private final SQLElementDirectory dir = Configuration.getInstance().getDirectory();

    public JoinOrderByOwner(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected void changeImpl(SQLTable t) throws SQLException {
        SQLElement element = this.dir.getElement(t);
        if (!(element instanceof JoinSQLElement)) {
            return;
        }
        JoinSQLElement joinElem = (JoinSQLElement)element;
        this.getStream().print(String.valueOf(t.getName()) + "... ");
        if (!t.isOrdered()) {
            this.getStream().println("not ordered");
        } else {
            List<String> twoCols;
            Set<Constraint> twoFieldsConstraints;
            Constraint oneFieldConstraint = t.getConstraint(SQLSyntax.ConstraintType.UNIQUE, Arrays.asList(t.getOrderField().getName()));
            AlterTable alterTable = new AlterTable(t);
            if (oneFieldConstraint != null) {
                this.getStream().print("removing unique constraint on field " + oneFieldConstraint.getCols());
                alterTable.dropConstraint(oneFieldConstraint.getName());
            }
            if ((twoFieldsConstraints = t.getConstraints(SQLSyntax.ConstraintType.UNIQUE, twoCols = Arrays.asList(t.getOrderField().getName(), joinElem.getStepFromOwner().getSingleField().getName()), true)).size() > 1) {
                this.getStream().print(" WARNING multiple unique constraints : " + twoFieldsConstraints);
            } else if (twoFieldsConstraints.size() == 0 || twoFieldsConstraints.size() == 1 && CollectionUtils.getSole(twoFieldsConstraints).getCols().size() > 2) {
                this.getStream().print(" creating unique constraint");
                alterTable.addUniqueConstraint("orderUniq", twoCols);
            }
            if (!alterTable.isEmpty()) {
                this.getDS().execute(alterTable.asString());
                t.getSchema().updateVersion();
            }
            this.getStream().println(" done");
        }
    }
}

