/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Map;
import java.util.ResourceBundle;
import net.jcip.annotations.ThreadSafe;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.Dependency;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.erp.modules.ModuleVersion;

@ThreadSafe
public class VirtualModuleFactory
extends ModuleFactory {
    private final Map<Object, Dependency> depends;
    private final ListResourceBundle bundle;

    public VirtualModuleFactory(ModuleReference ref, String contact) {
        this(ref, contact, (List<Dependency>)null);
    }

    public VirtualModuleFactory(String id, ModuleVersion vers, String contact) {
        this(id, vers, contact, Collections.emptyList());
    }

    public VirtualModuleFactory(String id, ModuleVersion vers, String contact, List<Dependency> depends) {
        this(new ModuleReference(id, vers), contact, depends);
    }

    public VirtualModuleFactory(ModuleReference ref, String contact, List<Dependency> depends) {
        this(ref, contact, depends == null ? null : VirtualModuleFactory.createMap(depends));
    }

    private VirtualModuleFactory(ModuleReference ref, String contact, Map<Object, Dependency> depends) {
        super(ref, contact);
        this.depends = depends == null ? Collections.emptyMap() : Collections.unmodifiableMap(depends);
        this.bundle = new ListResourceBundle(){

            @Override
            protected Object[][] getContents() {
                return new Object[][]{{"name", VirtualModuleFactory.this.getID()}, {"description", String.valueOf(VirtualModuleFactory.this.getClass().getSimpleName()) + " for " + VirtualModuleFactory.this.getID()}};
            }
        };
    }

    @Override
    protected ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    @Override
    protected final Map<Object, Dependency> getDependencies() {
        return this.depends;
    }

    @Override
    public AbstractModule createModule(File moduleDir, Map<Object, AbstractModule> alreadyCreated) throws Exception {
        return new AbstractModule(this){

            @Override
            protected void stop() {
            }

            @Override
            protected void start() {
            }
        };
    }
}

