/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.sqlobject.SQLSearchableTextCombo;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.preferences.JavaPrefPreferencePanel;
import org.openconcerto.ui.preferences.PrefView;
import org.openconcerto.utils.PrefType;

public abstract class ModulePreferencePanel
extends JavaPrefPreferencePanel {
    private static DBRoot getRoot() {
        return ModuleManager.getInstance().getRoot();
    }

    static String getAppPrefPath() {
        return String.valueOf(Configuration.getInstance().getAppID()) + '/';
    }

    public ModulePreferencePanel(String title) {
        super(title, null);
    }

    public final void init(ModuleFactory module, boolean local) {
        this.setPrefs(module.getPreferences(local, ModulePreferencePanel.getRoot()));
    }

    public static class SQLPrefView<T>
    extends PrefView<T> {
        public SQLPrefView(PrefType<T> type, String name, String prefKey) {
            super(type, name, prefKey);
        }

        public SQLPrefView(PrefType<T> type, int length, String name, String prefKey) {
            super(type, length, name, prefKey);
        }

        @Override
        protected JComponent createComponent() {
            JComponent comp = Boolean.class.isAssignableFrom(this.getViewClass()) ? new JCheckBox(" ") : (Date.class.isAssignableFrom(this.getViewClass()) ? new JDate() : (String.class.isAssignableFrom(this.getViewClass()) && this.getLength() >= 512 ? new SQLSearchableTextCombo(ComboLockedMode.UNLOCKED, true) : new SQLTextCombo(false)));
            return comp;
        }

        @Override
        public void init(JavaPrefPreferencePanel prefPanel) {
            JComponent comp = this.getVW().getComp();
            if (comp instanceof SQLTextCombo) {
                ((SQLTextCombo)comp).initCache(this.createCache(prefPanel));
            } else if (comp instanceof SQLSearchableTextCombo) {
                ((SQLSearchableTextCombo)comp).initCache(new SQLSearchableTextCombo.ISQLListModel(this.createCache(prefPanel)).load());
            }
        }

        private SQLTextCombo.ITextComboCacheSQL createCache(JavaPrefPreferencePanel prefPanel) {
            return new SQLTextCombo.ITextComboCacheSQL(ModulePreferencePanel.getRoot(), String.valueOf(prefPanel.getPrefPath()) + '/' + this.getPrefKey());
        }
    }
}

